/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.fcd.proV1;

import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.source.tuner.fcd.FCDTuner;
import io.github.dsheirer.source.tuner.fcd.proV1.FCD1TunerConfiguration;
import io.github.dsheirer.source.tuner.fcd.proV1.FCD1TunerController;
import io.github.dsheirer.source.tuner.manager.DiscoveredTuner;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import io.github.dsheirer.source.tuner.ui.TunerEditor;
import java.awt.Component;
import java.awt.LayoutManager;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FCD1TunerEditor
extends TunerEditor<FCDTuner, FCD1TunerConfiguration> {
    private static final long serialVersionUID = 1L;
    private static final Logger mLog = LoggerFactory.getLogger(FCD1TunerEditor.class);
    private JButton mTunerInfoButton;
    private JComboBox<FCD1TunerController.LNAGain> mLnaGainCombo;
    private JComboBox<FCD1TunerController.LNAEnhance> mLnaEnhanceCombo;
    private JComboBox<FCD1TunerController.MixerGain> mMixerGainCombo;
    private CorrectionSpinner mCorrectionDCI;
    private CorrectionSpinner mCorrectionDCQ;
    private CorrectionSpinner mGainCorrectionSpinner;
    private CorrectionSpinner mPhaseCorrectionSpinner;

    public FCD1TunerEditor(UserPreferences userPreferences, TunerManager tunerManager, DiscoveredTuner discoveredTuner) {
        super(userPreferences, tunerManager, discoveredTuner);
        this.init();
        this.tunerStatusUpdated();
    }

    private FCD1TunerController getController() {
        if (this.hasTuner()) {
            return (FCD1TunerController)((FCDTuner)this.getTuner()).getController();
        }
        return null;
    }

    @Override
    protected void tunerStatusUpdated() {
        this.setLoading(true);
        if (this.hasTuner()) {
            this.getTunerIdLabel().setText(((FCDTuner)this.getTuner()).getPreferredName());
        } else {
            this.getTunerIdLabel().setText(this.getDiscoveredTuner().getId());
        }
        Object status = this.getDiscoveredTuner().getTunerStatus().toString();
        if (this.getDiscoveredTuner().hasErrorMessage()) {
            status = (String)status + " - " + this.getDiscoveredTuner().getErrorMessage();
        }
        this.getTunerStatusLabel().setText((String)status);
        this.getButtonPanel().updateControls();
        this.getFrequencyPanel().updateControls();
        this.getTunerInfoButton().setEnabled(this.hasTuner());
        if (this.hasTuner() && this.hasConfiguration()) {
            this.getMixerGainCombo().setSelectedItem((Object)((FCD1TunerConfiguration)this.getConfiguration()).getMixerGain());
            this.getLnaEnhanceCombo().setSelectedItem((Object)((FCD1TunerConfiguration)this.getConfiguration()).getLNAEnhance());
            this.getLnaGainCombo().setSelectedItem((Object)((FCD1TunerConfiguration)this.getConfiguration()).getLNAGain());
            this.getDcCorrectionSpinnerI().setValue(((FCD1TunerConfiguration)this.getConfiguration()).getInphaseDCCorrection());
            this.getDcCorrectionSpinnerQ().setValue(((FCD1TunerConfiguration)this.getConfiguration()).getQuadratureDCCorrection());
            this.getPhaseCorrectionSpinner().setValue(((FCD1TunerConfiguration)this.getConfiguration()).getGainCorrection());
            this.getGainCorrectionSpinner().setValue(((FCD1TunerConfiguration)this.getConfiguration()).getPhaseCorrection());
        }
        this.getMixerGainCombo().setEnabled(this.hasTuner());
        this.getLnaEnhanceCombo().setEnabled(this.hasTuner());
        this.getLnaGainCombo().setEnabled(this.hasTuner());
        this.getDcCorrectionSpinnerI().setEnabled(this.hasTuner());
        this.getDcCorrectionSpinnerQ().setEnabled(this.hasTuner());
        this.getPhaseCorrectionSpinner().setEnabled(this.hasTuner());
        this.getGainCorrectionSpinner().setEnabled(this.hasTuner());
        this.setLoading(false);
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("fill,wrap 3", "[right][grow,fill][fill]", "[][][][][][][][][][][][][][][][][grow]"));
        this.add(new JLabel("Tuner:"));
        this.add(this.getTunerIdLabel());
        this.add(this.getTunerInfoButton());
        this.add(new JLabel("Status:"));
        this.add((Component)this.getTunerStatusLabel(), "wrap");
        this.add((Component)this.getButtonPanel(), "span,align left");
        this.add((Component)new JSeparator(), "span,growx,push");
        this.add(new JLabel("Frequency (MHz):"));
        this.add((Component)this.getFrequencyPanel(), "wrap");
        this.add((Component)new JSeparator(), "span,growx,push");
        this.add((Component)new JLabel("Gain"), "span,align center");
        this.add(new JLabel("LNA:"));
        this.add((Component)this.getLnaGainCombo(), "wrap");
        this.add(new JLabel("Enhance:"));
        this.add((Component)this.getLnaEnhanceCombo(), "wrap");
        this.add(new JLabel("Mixer:"));
        this.add((Component)this.getMixerGainCombo(), "wrap");
        this.add((Component)new JSeparator(), "span,growx,push");
        this.add((Component)new JLabel("Correction"), "span,align center");
        this.add(new JLabel("DC Inphase:"));
        this.add((Component)this.getDcCorrectionSpinnerI(), "wrap");
        this.add(new JLabel("DC Quadrature:"));
        this.add((Component)this.getDcCorrectionSpinnerQ(), "wrap");
        this.add(new JLabel("Gain:"));
        this.add((Component)this.getGainCorrectionSpinner(), "wrap");
        this.add(new JLabel("Phase:"));
        this.add((Component)this.getPhaseCorrectionSpinner(), "wrap");
    }

    public JComboBox getLnaGainCombo() {
        if (this.mLnaGainCombo == null) {
            this.mLnaGainCombo = new JComboBox<FCD1TunerController.LNAGain>(FCD1TunerController.LNAGain.values());
            this.mLnaGainCombo.setEnabled(false);
            this.mLnaGainCombo.setToolTipText("Adjust the low noise amplifier gain setting.");
            this.mLnaGainCombo.addActionListener(arg0 -> {
                if (!this.isLoading()) {
                    FCD1TunerController.LNAGain gain = (FCD1TunerController.LNAGain)((Object)((Object)this.mLnaGainCombo.getSelectedItem()));
                    try {
                        this.getController().setLNAGain(gain);
                        this.save();
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this, "FCD Pro Tuner Controller - error setting LNA gain [" + String.valueOf((Object)gain) + "]");
                        mLog.error("FuncubeDonglePro Controller - error setting gain [" + String.valueOf((Object)gain) + "]", (Throwable)e);
                    }
                }
            });
        }
        return this.mLnaGainCombo;
    }

    public JComboBox getLnaEnhanceCombo() {
        if (this.mLnaEnhanceCombo == null) {
            this.mLnaEnhanceCombo = new JComboBox<FCD1TunerController.LNAEnhance>(FCD1TunerController.LNAEnhance.values());
            this.mLnaEnhanceCombo.setEnabled(false);
            this.mLnaEnhanceCombo.setToolTipText("Adjust the LNA enhance setting.  Default value is OFF");
            this.mLnaEnhanceCombo.addActionListener(arg0 -> {
                if (!this.isLoading()) {
                    FCD1TunerController.LNAEnhance enhance = (FCD1TunerController.LNAEnhance)((Object)((Object)this.mLnaEnhanceCombo.getSelectedItem()));
                    try {
                        this.getController().setLNAEnhance(enhance);
                        this.save();
                    }
                    catch (Exception e1) {
                        JOptionPane.showMessageDialog(this, "FCD Pro Tuner error setting LNA enhance gain [" + String.valueOf((Object)enhance) + "]");
                        mLog.error("FCDPro - error setting LNA enhance  [" + String.valueOf((Object)enhance) + "]", (Throwable)e1);
                    }
                }
            });
        }
        return this.mLnaEnhanceCombo;
    }

    public JComboBox getMixerGainCombo() {
        if (this.mMixerGainCombo == null) {
            this.mMixerGainCombo = new JComboBox<FCD1TunerController.MixerGain>(FCD1TunerController.MixerGain.values());
            this.mMixerGainCombo.setEnabled(false);
            this.mMixerGainCombo.setToolTipText("Adjust mixer gain setting");
            this.mMixerGainCombo.addActionListener(arg0 -> {
                if (!this.isLoading()) {
                    FCD1TunerController.MixerGain gain = (FCD1TunerController.MixerGain)((Object)((Object)this.mMixerGainCombo.getSelectedItem()));
                    try {
                        this.getController().setMixerGain(gain);
                        this.save();
                    }
                    catch (Exception e1) {
                        JOptionPane.showMessageDialog(this, "FCDPro - error setting mixer gain [" + String.valueOf((Object)gain) + "]");
                        mLog.error("FCDPro - error setting mixer gain [" + String.valueOf((Object)gain) + "]", (Throwable)e1);
                    }
                }
            });
        }
        return this.mMixerGainCombo;
    }

    public CorrectionSpinner getDcCorrectionSpinnerQ() {
        if (this.mCorrectionDCQ == null) {
            this.mCorrectionDCQ = new CorrectionSpinner(Correction.DC_QUADRATURE, 0.0, 1.0E-5, 5);
            this.mCorrectionDCQ.setEnabled(false);
            this.mCorrectionDCQ.setToolTipText("DC Bias Correction/Quadrature Component: valid values are -1.0 to 1.0 (default: 0.0)");
        }
        return this.mCorrectionDCQ;
    }

    public CorrectionSpinner getDcCorrectionSpinnerI() {
        if (this.mCorrectionDCI == null) {
            this.mCorrectionDCI = new CorrectionSpinner(Correction.DC_INPHASE, 0.0, 1.0E-5, 5);
            this.mCorrectionDCI.setEnabled(false);
            this.mCorrectionDCI.setToolTipText("DC Bias Correction/Inphase Component: valid values are -1.0 to 1.0 (default: 0.0)");
        }
        return this.mCorrectionDCI;
    }

    public CorrectionSpinner getGainCorrectionSpinner() {
        if (this.mGainCorrectionSpinner == null) {
            this.mGainCorrectionSpinner = new CorrectionSpinner(Correction.GAIN, 0.0, 1.0E-5, 5);
            this.mGainCorrectionSpinner.setEnabled(false);
            this.mGainCorrectionSpinner.setToolTipText("Gain Correction: valid values are -1.0 to 1.0 (default: 0.0)");
        }
        return this.mGainCorrectionSpinner;
    }

    public CorrectionSpinner getPhaseCorrectionSpinner() {
        if (this.mPhaseCorrectionSpinner == null) {
            this.mPhaseCorrectionSpinner = new CorrectionSpinner(Correction.PHASE, 0.0, 1.0E-5, 5);
            this.mPhaseCorrectionSpinner.setEnabled(false);
            this.mPhaseCorrectionSpinner.setToolTipText("Phase Correction: valid values are -1.0 to 1.0 (default: 0.0)");
        }
        return this.mPhaseCorrectionSpinner;
    }

    @Override
    public void setTunerLockState(boolean locked) {
        this.getFrequencyPanel().updateControls();
    }

    public JButton getTunerInfoButton() {
        if (this.mTunerInfoButton == null) {
            this.mTunerInfoButton = new JButton("Tuner Info");
            this.mTunerInfoButton.setEnabled(false);
            this.mTunerInfoButton.addActionListener(e -> JOptionPane.showMessageDialog(this, this.getTunerInfo(), "Tuner Info", 1));
        }
        return this.mTunerInfoButton;
    }

    private String getTunerInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><h3>Funcube Dongle Pro Tuner</h3>");
        if (this.hasTuner()) {
            sb.append("<b>USB ID: </b>");
            sb.append(this.getController().getUSBID());
            sb.append("<br>");
            sb.append("<b>USB Address: </b>");
            sb.append(this.getController().getUSBAddress());
            sb.append("<br>");
            sb.append("<b>USB Speed: </b>");
            sb.append(this.getController().getUSBSpeed());
            sb.append("<br>");
            sb.append("<b>Cellular Band: </b>");
            sb.append((Object)this.getController().getConfiguration().getBandBlocking());
            sb.append("<br>");
            sb.append("<b>Firmware: </b>");
            sb.append(this.getController().getConfiguration().getFirmware());
            sb.append("<br>");
        }
        return sb.toString();
    }

    @Override
    public void save() {
        if (this.hasConfiguration() && !this.isLoading()) {
            ((FCD1TunerConfiguration)this.getConfiguration()).setFrequency(this.getFrequencyControl().getFrequency());
            double value = ((SpinnerNumberModel)this.getFrequencyCorrectionSpinner().getModel()).getNumber().doubleValue();
            ((FCD1TunerConfiguration)this.getConfiguration()).setFrequencyCorrection(value);
            ((FCD1TunerConfiguration)this.getConfiguration()).setAutoPPMCorrectionEnabled(this.getAutoPPMCheckBox().isSelected());
            ((FCD1TunerConfiguration)this.getConfiguration()).setLNAEnhance((FCD1TunerController.LNAEnhance)((Object)this.mLnaEnhanceCombo.getSelectedItem()));
            ((FCD1TunerConfiguration)this.getConfiguration()).setLNAGain((FCD1TunerController.LNAGain)((Object)this.mLnaGainCombo.getSelectedItem()));
            ((FCD1TunerConfiguration)this.getConfiguration()).setMixerGain((FCD1TunerController.MixerGain)((Object)this.mMixerGainCombo.getSelectedItem()));
            double dci = ((SpinnerNumberModel)this.mCorrectionDCI.getModel()).getNumber().doubleValue();
            ((FCD1TunerConfiguration)this.getConfiguration()).setInphaseDCCorrection(dci);
            double dcq = ((SpinnerNumberModel)this.mCorrectionDCQ.getModel()).getNumber().doubleValue();
            ((FCD1TunerConfiguration)this.getConfiguration()).setQuadratureDCCorrection(dcq);
            double gain = ((SpinnerNumberModel)this.mGainCorrectionSpinner.getModel()).getNumber().doubleValue();
            ((FCD1TunerConfiguration)this.getConfiguration()).setGainCorrection(gain);
            double phase = ((SpinnerNumberModel)this.mPhaseCorrectionSpinner.getModel()).getNumber().doubleValue();
            ((FCD1TunerConfiguration)this.getConfiguration()).setPhaseCorrection(phase);
            this.saveConfiguration();
        }
    }

    public class CorrectionSpinner
    extends JSpinner {
        private static final long serialVersionUID = 1L;
        private static final double MIN_VALUE = -1.0;
        private static final double MAX_VALUE = 1.0;
        private Correction mCorrectionComponent;

        public CorrectionSpinner(Correction component, double initialValue, double step, int decimalPlaces) {
            this.mCorrectionComponent = component;
            SpinnerNumberModel model = new SpinnerNumberModel(initialValue, -1.0, 1.0, step);
            this.setModel(model);
            JSpinner.NumberEditor editor = (JSpinner.NumberEditor)this.getEditor();
            DecimalFormat format = editor.getFormat();
            format.setMinimumFractionDigits(decimalPlaces);
            editor.getTextField().setHorizontalAlignment(0);
            this.addChangeListener(e -> {
                if (!FCD1TunerEditor.this.isLoading()) {
                    double value = ((SpinnerNumberModel)this.getModel()).getNumber().doubleValue();
                    try {
                        switch (this.mCorrectionComponent) {
                            case DC_INPHASE: {
                                FCD1TunerEditor.this.getController().setDCCorrectionInPhase(value);
                                break;
                            }
                            case DC_QUADRATURE: {
                                FCD1TunerEditor.this.getController().setDCCorrectionQuadrature(value);
                                break;
                            }
                            case GAIN: {
                                FCD1TunerEditor.this.getController().setGainCorrection(value);
                                break;
                            }
                            case PHASE: {
                                FCD1TunerEditor.this.getController().setPhaseCorrection(value);
                            }
                        }
                        FCD1TunerEditor.this.save();
                    }
                    catch (Exception e1) {
                        JOptionPane.showMessageDialog(FCD1TunerEditor.this, "FCDPro - error applying " + this.mCorrectionComponent.toString() + " correction value [" + value + "]");
                        mLog.error("FCDPro - error applying " + this.mCorrectionComponent.toString() + " correction value [" + value + "]", (Throwable)e1);
                    }
                }
            });
        }
    }

    public static enum Correction {
        GAIN,
        PHASE,
        DC_INPHASE,
        DC_QUADRATURE;

    }
}

