/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.fcd;

import io.github.dsheirer.buffer.INativeBuffer;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.adapter.ComplexShortAdapter;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.mixer.ComplexMixer;
import io.github.dsheirer.source.tuner.ITunerErrorListener;
import io.github.dsheirer.source.tuner.MixerTunerType;
import io.github.dsheirer.source.tuner.TunerClass;
import io.github.dsheirer.source.tuner.TunerController;
import io.github.dsheirer.source.tuner.TunerType;
import io.github.dsheirer.source.tuner.fcd.FCDCommand;
import io.github.dsheirer.source.tuner.fcd.FCDModel;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.concurrent.locks.ReentrantLock;
import javax.sound.sampled.TargetDataLine;
import javax.usb.UsbClaimException;
import javax.usb.UsbException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.usb4java.Context;
import org.usb4java.Device;
import org.usb4java.DeviceDescriptor;
import org.usb4java.DeviceHandle;
import org.usb4java.DeviceList;
import org.usb4java.LibUsb;
import org.usb4java.LibUsbException;

public abstract class FCDTunerController
extends TunerController {
    private static final Logger mLog = LoggerFactory.getLogger(FCDTunerController.class);
    private static final double USABLE_BANDWIDTH_PERCENT = 1.0;
    private static final int DC_SPIKE_AVOID_HALF_BANDWIDTH = 5000;
    private static final byte FCD_INTERFACE = 2;
    private static final byte FCD_ENDPOINT_IN = -126;
    private static final byte FCD_ENDPOINT_OUT = 2;
    private int mBus;
    private String mPortAddress;
    private Context mDeviceContext = new Context();
    private Device mDevice;
    private DeviceDescriptor mDeviceDescriptor = new DeviceDescriptor();
    private DeviceHandle mDeviceHandle = new DeviceHandle();
    private FCDConfiguration mConfiguration = new FCDConfiguration(this);
    protected ComplexMixer mComplexMixer;
    private ReentrantLock mListenerLock = new ReentrantLock();

    public FCDTunerController(MixerTunerType tunerType, TargetDataLine mixerTDL, int bus, String portAddress, int minTunableFrequency, int maxTunableFrequency, ITunerErrorListener tunerErrorListener) {
        super(tunerErrorListener);
        this.mBus = bus;
        this.mPortAddress = portAddress;
        this.setMinimumFrequency(minTunableFrequency);
        this.setMaximumFrequency(maxTunableFrequency);
        this.setMiddleUnusableHalfBandwidth(5000);
        this.setUsableBandwidthPercentage(1.0);
        try {
            this.mFrequencyController.setSampleRate((int)tunerType.getAudioFormat().getSampleRate());
        }
        catch (SourceException se) {
            mLog.error("Error setting sample rate to [" + tunerType.getAudioFormat().getSampleRate() + "]", (Throwable)se);
        }
        this.mComplexMixer = new ComplexMixer(mixerTDL, tunerType.getAudioFormat(), tunerType.getDisplayString(), new ComplexShortAdapter());
        this.mComplexMixer.setBufferSampleCount(this.getBufferSampleCount());
        this.mComplexMixer.setBufferListener(this.mNativeBufferBroadcaster);
    }

    @Override
    public int getBufferSampleCount() {
        if (this.getTunerType() == TunerType.FUNCUBE_DONGLE_PRO) {
            return 4096;
        }
        if (this.getTunerType() == TunerType.FUNCUBE_DONGLE_PRO_PLUS) {
            return 8192;
        }
        throw new IllegalStateException("Unrecognized tuner type: " + String.valueOf((Object)this.getTunerType()));
    }

    @Override
    public void addBufferListener(Listener<INativeBuffer> listener) {
        this.mListenerLock.lock();
        try {
            boolean hasExistingListeners = this.hasBufferListeners();
            super.addBufferListener(listener);
            if (!hasExistingListeners) {
                this.mComplexMixer.start();
            }
        }
        finally {
            this.mListenerLock.unlock();
        }
    }

    @Override
    public void removeBufferListener(Listener<INativeBuffer> listener) {
        this.mListenerLock.lock();
        try {
            ComplexMixer complexMixer;
            super.removeBufferListener(listener);
            if (!this.hasBufferListeners() && (complexMixer = this.mComplexMixer) != null) {
                complexMixer.stop();
            }
        }
        finally {
            this.mListenerLock.unlock();
        }
    }

    private Device findDevice() throws SourceException {
        Device foundDevice = null;
        DeviceList deviceList = new DeviceList();
        int count = LibUsb.getDeviceList((Context)this.mDeviceContext, (DeviceList)deviceList);
        if (count >= 0) {
            for (Device device : deviceList) {
                int bus = LibUsb.getBusNumber((Device)device);
                int port = LibUsb.getPortNumber((Device)device);
                if (port > 0) {
                    String portAddress = TunerManager.getPortAddress(device);
                    if (this.mBus == bus && this.mPortAddress != null && this.mPortAddress.equals(portAddress)) {
                        foundDevice = device;
                        continue;
                    }
                    LibUsb.unrefDevice((Device)device);
                    continue;
                }
                LibUsb.unrefDevice((Device)device);
            }
        } else {
            throw new SourceException("LibUsb couldn't discover USB device [" + this.mBus + ":" + this.mPortAddress + "] from device list" + (String)(count < 0 ? " - error: " + LibUsb.errorName((int)count) : ""));
        }
        if (foundDevice == null) {
            throw new SourceException("LibUsb couldn't find the matching USB device");
        }
        return foundDevice;
    }

    @Override
    public void start() throws SourceException {
        if (this.mDeviceContext == null) {
            throw new SourceException("Device cannot be reused once it has been shutdown");
        }
        int status = LibUsb.init((Context)this.mDeviceContext);
        if (status != 0) {
            throw new SourceException("Can't initialize libusb library - " + LibUsb.errorName((int)status));
        }
        this.mDevice = this.findDevice();
        this.mDeviceDescriptor = new DeviceDescriptor();
        status = LibUsb.getDeviceDescriptor((Device)this.mDevice, (DeviceDescriptor)this.mDeviceDescriptor);
        if (status != 0) {
            this.mDeviceDescriptor = null;
            throw new SourceException("Can't obtain tuner's device descriptor - " + LibUsb.errorName((int)status));
        }
        this.mDeviceHandle = new DeviceHandle();
        status = LibUsb.open((Device)this.mDevice, (DeviceHandle)this.mDeviceHandle);
        if (status != 0) {
            this.mDeviceHandle = null;
            this.mDeviceDescriptor = null;
            mLog.error("Can't open USB tuner [" + String.valueOf((Object)this.getTunerType()) + "] - check driver or Linux udev rules");
            throw new SourceException("Can't open USB tuner - check driver or Linux udev rules - " + LibUsb.errorName((int)status));
        }
        status = LibUsb.kernelDriverActive((DeviceHandle)this.mDeviceHandle, (int)2);
        if (status == 1 && (status = LibUsb.detachKernelDriver((DeviceHandle)this.mDeviceHandle, (int)2)) != 0) {
            mLog.error("Unable to detach kernel driver for USB tuner device - bus:" + this.mBus + " port:" + this.mPortAddress);
            this.mDeviceHandle = null;
            this.mDeviceDescriptor = null;
            throw new SourceException("Can't detach kernel driver");
        }
        status = LibUsb.claimInterface((DeviceHandle)this.mDeviceHandle, (int)2);
        if (status == -6) {
            this.mDeviceHandle = null;
            this.mDeviceDescriptor = null;
            throw new SourceException("USB tuner is in-use by another application");
        }
        if (status != 0) {
            this.mDeviceHandle = null;
            this.mDeviceDescriptor = null;
            throw new SourceException("Can't claim interface on USB tuner - " + LibUsb.errorName((int)status));
        }
        this.deviceStart();
    }

    protected abstract void deviceStart() throws SourceException;

    @Override
    public void stop() {
        if (this.mComplexMixer != null) {
            this.mComplexMixer.stop();
            this.mComplexMixer = null;
        }
        if (this.mDeviceHandle != null) {
            try {
                LibUsb.close((DeviceHandle)this.mDeviceHandle);
            }
            catch (Exception e) {
                mLog.error("error while closing device handle", (Throwable)e);
            }
        }
        this.mDeviceDescriptor = null;
        this.mDeviceHandle = null;
        this.mDevice = null;
        LibUsb.exit((Context)this.mDeviceContext);
        this.mDeviceContext = null;
    }

    @Override
    public abstract double getCurrentSampleRate();

    public abstract TunerClass getTunerClass();

    @Override
    public abstract TunerType getTunerType();

    public String getUSBAddress() {
        if (this.mDevice != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Bus:");
            int bus = LibUsb.getBusNumber((Device)this.mDevice);
            sb.append(bus);
            sb.append(" Port:");
            int port = LibUsb.getPortNumber((Device)this.mDevice);
            sb.append(port);
            return sb.toString();
        }
        return "UNKNOWN";
    }

    public String getUSBID() {
        if (this.mDeviceDescriptor != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("%04X", this.mDeviceDescriptor.idVendor() & 0xFFFF));
            sb.append(":");
            sb.append(String.format("%04X", this.mDeviceDescriptor.idProduct() & 0xFFFF));
            return sb.toString();
        }
        return "UNKNOWN";
    }

    public String getUSBSpeed() {
        if (this.mDevice != null) {
            int speed = LibUsb.getDeviceSpeed((Device)this.mDevice);
            switch (speed) {
                case 0: {
                    return "1.1 LOW";
                }
                case 1: {
                    return "1.1 FULL";
                }
                case 2: {
                    return "2.0 HIGH";
                }
                case 3: {
                    return "3.0 SUPER";
                }
            }
        }
        return "UNKNOWN";
    }

    public void setFCDMode(Mode mode) throws UsbException, UsbClaimException {
        ByteBuffer response = null;
        switch (mode) {
            case APPLICATION: {
                response = this.send(FCDCommand.BL_QUERY);
                break;
            }
            case BOOTLOADER: {
                response = this.send(FCDCommand.APP_RESET);
                break;
            }
        }
        if (response != null) {
            this.mConfiguration.set(response);
        } else {
            this.mConfiguration.setModeUnknown();
        }
    }

    @Override
    public void setTunedFrequency(long frequency) throws SourceException {
        this.mListenerLock.lock();
        try {
            this.send(FCDCommand.APP_SET_FREQUENCY_HZ, frequency);
        }
        catch (Exception e) {
            throw new SourceException("Couldn't set FCD Local Oscillator Frequency [" + frequency + "]", e);
        }
        finally {
            this.mListenerLock.unlock();
        }
    }

    @Override
    public long getTunedFrequency() throws SourceException {
        try {
            ByteBuffer buffer = this.send(FCDCommand.APP_GET_FREQUENCY_HZ);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            return buffer.getInt(2) & 0xFFFFFFFF;
        }
        catch (Exception e) {
            throw new SourceException("FCDTunerController - couldn't get LO frequency", e);
        }
    }

    public FCDConfiguration getConfiguration() {
        return this.mConfiguration;
    }

    private void write(ByteBuffer buffer) throws LibUsbException {
        if (this.mDeviceHandle != null) {
            IntBuffer transferred = IntBuffer.allocate(1);
            int result = LibUsb.interruptTransfer((DeviceHandle)this.mDeviceHandle, (byte)2, (ByteBuffer)buffer, (IntBuffer)transferred, (long)500L);
            if (result != 0) {
                throw new LibUsbException("error writing byte buffer", result);
            }
        } else {
            throw new LibUsbException("device handle is null", -4);
        }
    }

    private void write(FCDCommand command) throws LibUsbException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(64);
        buffer.put(0, command.getCommand());
        buffer.put(1, (byte)0);
        this.write(buffer);
    }

    private void write(FCDCommand command, long argument) throws LibUsbException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(64);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put(0, command.getCommand());
        buffer.putLong(1, argument);
        this.write(buffer);
    }

    private ByteBuffer read() throws LibUsbException {
        if (this.mDeviceHandle != null) {
            IntBuffer transferred;
            ByteBuffer buffer = ByteBuffer.allocateDirect(64);
            int result = LibUsb.interruptTransfer((DeviceHandle)this.mDeviceHandle, (byte)-126, (ByteBuffer)buffer, (IntBuffer)(transferred = IntBuffer.allocate(1)), (long)500L);
            if (result != 0) {
                throw new LibUsbException("error reading byte buffer", result);
            }
            if (transferred.get(0) != buffer.capacity()) {
                throw new LibUsbException("received bytes [" + transferred.get(0) + "] didn't match expected length [" + buffer.capacity() + "]", result);
            }
            return buffer;
        }
        throw new LibUsbException("device handle is null", -4);
    }

    protected synchronized void send(FCDCommand command, long argument) throws LibUsbException {
        this.write(command, argument);
        this.read();
    }

    protected ByteBuffer send(FCDCommand command) throws LibUsbException {
        this.write(command);
        return this.read();
    }

    public class FCDConfiguration {
        private String mConfig = null;
        private Mode mMode = Mode.UNKNOWN;

        public FCDConfiguration(FCDTunerController this$0) {
        }

        private void setModeUnknown() {
            this.mConfig = null;
            this.mMode = Mode.UNKNOWN;
        }

        public void set(ByteBuffer buffer) {
            if (buffer.capacity() == 64) {
                byte[] data = new byte[64];
                for (int x = 0; x < 64; ++x) {
                    data[x] = buffer.get(x);
                }
                this.mConfig = new String(data);
                this.mMode = Mode.getMode(this.mConfig);
            } else {
                this.mConfig = null;
                this.mMode = Mode.ERROR;
            }
        }

        public Mode getMode() {
            return this.mMode;
        }

        public FCDModel getModel() {
            FCDModel retVal = FCDModel.FUNCUBE_UNKNOWN;
            switch (this.mMode) {
                case APPLICATION: {
                    retVal = FCDModel.getFCD(this.mConfig.substring(15, 22));
                    break;
                }
            }
            return retVal;
        }

        public Block getBandBlocking() {
            Block retVal = Block.UNKNOWN;
            switch (this.mMode) {
                case APPLICATION: {
                    retVal = Block.getBlock(this.mConfig.substring(23, 33).trim());
                    break;
                }
            }
            return retVal;
        }

        public String getFirmware() {
            String retVal = null;
            switch (this.mMode) {
                case APPLICATION: {
                    retVal = this.mConfig.substring(9, 14);
                    break;
                }
            }
            return retVal;
        }

        public String toString() {
            return this.getModel().getLabel();
        }
    }

    public static enum Mode {
        APPLICATION,
        BOOTLOADER,
        ERROR,
        UNKNOWN;


        public static Mode getMode(String config) {
            Mode retVal = UNKNOWN;
            if (config == null) {
                retVal = ERROR;
            } else if (config.length() >= 8) {
                String mode = config.substring(2, 8).trim();
                if (mode.equalsIgnoreCase("FCDAPP")) {
                    retVal = APPLICATION;
                } else if (mode.equalsIgnoreCase("FCDBL")) {
                    retVal = BOOTLOADER;
                }
            }
            return retVal;
        }
    }

    public static enum Block {
        CELLULAR_BAND_BLOCKED("Blocked"),
        NO_BAND_BLOCK("Unblocked"),
        UNKNOWN("Unknown");

        private String mLabel;

        private Block(String label) {
            this.mLabel = label;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public static Block getBlock(String block) {
            Block retVal = UNKNOWN;
            if (block.equalsIgnoreCase("No blk")) {
                retVal = NO_BAND_BLOCK;
            } else if (block.equalsIgnoreCase("Cell blk")) {
                retVal = CELLULAR_BAND_BLOCKED;
            }
            return retVal;
        }
    }
}

