/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.fcd;

import io.github.dsheirer.preference.source.ChannelizerType;
import io.github.dsheirer.source.tuner.ITunerErrorListener;
import io.github.dsheirer.source.tuner.Tuner;
import io.github.dsheirer.source.tuner.TunerClass;
import io.github.dsheirer.source.tuner.TunerType;
import io.github.dsheirer.source.tuner.fcd.FCDTunerController;

public class FCDTuner
extends Tuner {
    public FCDTuner(FCDTunerController controller, ITunerErrorListener tunerErrorListener) {
        super(controller, tunerErrorListener, ChannelizerType.HETERODYNE);
    }

    @Override
    public String getPreferredName() {
        return String.valueOf((Object)this.getTunerType()) + " " + this.getUniqueID();
    }

    public FCDTunerController getController() {
        return (FCDTunerController)this.getTunerController();
    }

    @Override
    public TunerClass getTunerClass() {
        return this.getController().getTunerClass();
    }

    @Override
    public TunerType getTunerType() {
        return this.getController().getTunerType();
    }

    @Override
    public String getUniqueID() {
        return this.getController().getUSBAddress();
    }

    @Override
    public double getSampleSize() {
        return 16.0;
    }

    @Override
    public int getMaximumUSBBitsPerSecond() {
        return (int)this.getController().getCurrentSampleRate() * 32;
    }
}

