/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.configuration;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.source.tuner.TunerFactory;
import io.github.dsheirer.source.tuner.TunerType;
import io.github.dsheirer.source.tuner.configuration.DisabledTuner;
import io.github.dsheirer.source.tuner.configuration.TunerConfiguration;
import io.github.dsheirer.source.tuner.configuration.TunerConfigurationState;
import io.github.dsheirer.source.tuner.manager.DiscoveredTuner;
import io.github.dsheirer.source.tuner.manager.IDiscoveredTunerStatusListener;
import io.github.dsheirer.source.tuner.manager.TunerStatus;
import io.github.dsheirer.util.ThreadPool;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunerConfigurationManager
implements IDiscoveredTunerStatusListener {
    private static final Logger mLog = LoggerFactory.getLogger(TunerConfigurationManager.class);
    private static final String SETTINGS_FILE_NAME = "tuner_configuration.json";
    private UserPreferences mUserPreferences;
    private List<DisabledTuner> mDisabledTunerList = new ArrayList<DisabledTuner>();
    private List<TunerConfiguration> mTunerConfigurations = new ArrayList<TunerConfiguration>();
    private AtomicBoolean mSavePending = new AtomicBoolean();
    private Lock mLock = new ReentrantLock();

    public TunerConfigurationManager(UserPreferences userPreferences) {
        this.mUserPreferences = userPreferences;
        this.load();
    }

    private void load() {
        Path configPath = this.getConfigurationFilePath();
        if (Files.exists(configPath, new LinkOption[0])) {
            ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            try {
                TunerConfigurationState state = (TunerConfigurationState)objectMapper.readValue(configPath.toFile(), TunerConfigurationState.class);
                this.mDisabledTunerList.addAll(state.getDisabledTuners());
                this.mTunerConfigurations.addAll(state.getTunerConfigurations());
            }
            catch (IOException ioe) {
                mLog.error("Error loading tuner configuration file", (Throwable)ioe);
            }
        }
    }

    private Path getConfigurationFilePath() {
        return this.mUserPreferences.getDirectoryPreference().getDirectoryConfiguration().resolve(SETTINGS_FILE_NAME);
    }

    private void save() {
        TunerConfigurationState state = new TunerConfigurationState();
        this.mLock.lock();
        try {
            state.setDisabledTuners(new ArrayList<DisabledTuner>(this.mDisabledTunerList));
            state.setTunerConfigurations(new ArrayList<TunerConfiguration>(this.mTunerConfigurations));
        }
        catch (Exception e) {
            mLog.error("Error", (Throwable)e);
        }
        finally {
            this.mLock.unlock();
        }
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            objectMapper.writeValue(this.getConfigurationFilePath().toFile(), (Object)state);
        }
        catch (IOException ioe) {
            mLog.error("Error writing tuner configuration state to file [" + String.valueOf(this.getConfigurationFilePath()) + "]", (Throwable)ioe);
        }
    }

    public void saveConfigurations() {
        if (this.mSavePending.compareAndSet(false, true)) {
            ThreadPool.SCHEDULED.schedule(new ConfigurationSaveTask(), 2L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void tunerStatusUpdated(DiscoveredTuner discoveredTuner, TunerStatus previous, TunerStatus current) {
        if (current == TunerStatus.DISABLED) {
            this.addDisabledTuner(discoveredTuner);
        } else if (current == TunerStatus.ENABLED) {
            TunerConfiguration tunerConfiguration;
            TunerType tunerType;
            this.removeDisabledTuner(discoveredTuner);
            if (discoveredTuner.hasTuner() && (tunerType = discoveredTuner.getTuner().getTunerType()) != TunerType.RECORDING && (tunerConfiguration = this.getTunerConfiguration(tunerType, discoveredTuner.getId())) != null) {
                discoveredTuner.setTunerConfiguration(tunerConfiguration);
                this.saveConfigurations();
            }
        }
    }

    private void addDisabledTuner(DiscoveredTuner discoveredTuner) {
        if (!this.isDisabled(discoveredTuner)) {
            this.mLock.lock();
            try {
                this.mDisabledTunerList.add(new DisabledTuner(discoveredTuner.getTunerClass(), discoveredTuner.getId()));
            }
            finally {
                this.mLock.unlock();
            }
            this.saveConfigurations();
        }
    }

    private void removeDisabledTuner(DiscoveredTuner discoveredTuner) {
        this.mLock.lock();
        try {
            this.mDisabledTunerList.removeIf(tuner -> tuner.matches(discoveredTuner));
        }
        finally {
            this.mLock.unlock();
        }
        this.saveConfigurations();
    }

    public boolean isDisabled(DiscoveredTuner discoveredTuner) {
        return this.findDisabledTuner(discoveredTuner) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DisabledTuner findDisabledTuner(DiscoveredTuner discoveredTuner) {
        DisabledTuner found = null;
        this.mLock.lock();
        try {
            for (DisabledTuner disabledTuner : this.mDisabledTunerList) {
                if (!disabledTuner.matches(discoveredTuner)) continue;
                found = disabledTuner;
                break;
            }
        }
        finally {
            this.mLock.unlock();
        }
        return found;
    }

    public void addTunerConfiguration(TunerConfiguration tunerConfiguration) {
        if (!this.mTunerConfigurations.stream().filter(config -> config.getTunerType().equals((Object)tunerConfiguration.getTunerType()) && config.getUniqueID().equalsIgnoreCase(tunerConfiguration.getUniqueID())).findFirst().isPresent()) {
            this.mTunerConfigurations.add(tunerConfiguration);
            this.saveConfigurations();
        }
    }

    public void removeTunerConfiguration(TunerConfiguration tunerConfiguration) {
        this.mTunerConfigurations.remove(tunerConfiguration);
        this.saveConfigurations();
    }

    public TunerConfiguration getTunerConfiguration(TunerType type, String uniqueID) {
        Optional<TunerConfiguration> optional = this.mTunerConfigurations.stream().filter(config -> config.getTunerType().equals((Object)type) && config.getUniqueID().equalsIgnoreCase(uniqueID)).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        TunerConfiguration config2 = TunerFactory.getTunerConfiguration(type, uniqueID);
        this.addTunerConfiguration(config2);
        return config2;
    }

    public List<TunerConfiguration> getTunerConfigurations(TunerType tunerType) {
        return this.mTunerConfigurations.stream().filter(tunerConfiguration -> tunerConfiguration.getTunerType().equals((Object)tunerType)).toList();
    }

    public class ConfigurationSaveTask
    implements Runnable {
        @Override
        public void run() {
            try {
                TunerConfigurationManager.this.save();
            }
            catch (Exception e) {
                mLog.error("Error saving tuner configurations", (Throwable)e);
            }
            TunerConfigurationManager.this.mSavePending.set(false);
        }
    }
}

