/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.channel;

public class TunerChannel
implements Comparable<TunerChannel> {
    private long mFrequency;
    private int mBandwidth;

    public TunerChannel(long frequency, int bandwidth) {
        this.mFrequency = frequency;
        this.mBandwidth = bandwidth;
    }

    public long getFrequency() {
        return this.mFrequency;
    }

    public void setFrequency(long frequency) {
        this.mFrequency = frequency;
    }

    public int getBandwidth() {
        return this.mBandwidth;
    }

    public void setBandwidth(int bandwidth) {
        this.mBandwidth = bandwidth;
    }

    public long getMinFrequency() {
        return this.mFrequency - (long)(this.mBandwidth / 2);
    }

    public long getMaxFrequency() {
        return this.mFrequency + (long)(this.mBandwidth / 2);
    }

    public boolean overlaps(long minimum, long maximum) {
        long channelMin = this.getMinFrequency();
        long channelMax = this.getMaxFrequency();
        return minimum <= channelMin && channelMin <= maximum || minimum <= channelMax && channelMax <= maximum || minimum <= channelMin && channelMax <= maximum || channelMin <= minimum && maximum <= channelMax;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Channel:").append(this.getFrequency()).append(" (").append(this.getMinFrequency());
        sb.append("-").append(this.getMaxFrequency()).append(")");
        return sb.toString();
    }

    @Override
    public int compareTo(TunerChannel otherLock) {
        return Long.compare(this.getFrequency(), otherLock.getFrequency());
    }

    public boolean equals(Object o) {
        if (!(o instanceof TunerChannel)) {
            return false;
        }
        return this.compareTo((TunerChannel)o) == 0;
    }
}

