/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.channel;

import com.google.common.eventbus.Subscribe;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.source.Source;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.heartbeat.Heartbeat;
import io.github.dsheirer.source.tuner.channel.ChannelSpecification;
import io.github.dsheirer.source.tuner.channel.TunerChannel;
import io.github.dsheirer.source.tuner.channel.TunerChannelSource;
import io.github.dsheirer.source.tuner.channel.rotation.FrequencyLockChangeRequest;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import io.github.dsheirer.util.ThreadPool;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiFrequencyTunerChannelSource
extends TunerChannelSource {
    private static final Logger mLog = LoggerFactory.getLogger(MultiFrequencyTunerChannelSource.class);
    private TunerManager mTunerManager;
    private TunerChannelSource mTunerChannelSource;
    private List<Long> mFrequencies;
    private List<Long> mLockedFrequencies = new ArrayList<Long>();
    private int mFrequencyListPointer = 0;
    private ChannelSpecification mChannelSpecification;
    private Listener<ComplexSamples> mComplexSamplesListener;
    private Listener<Heartbeat> mHeartbeatListener;
    private String mPreferredTuner;
    private AtomicBoolean mChangingChannels = new AtomicBoolean();
    private boolean mStarted;
    private ConsumerSourceEventAdapter mConsumerSourceEventAdapter = new ConsumerSourceEventAdapter();

    public MultiFrequencyTunerChannelSource(TunerManager tunerManager, TunerChannelSource tunerChannelSource, List<Long> frequencies, ChannelSpecification channelSpecification, String preferredTuner) {
        super(null, tunerChannelSource.getTunerChannel());
        this.mTunerManager = tunerManager;
        this.mTunerChannelSource = tunerChannelSource;
        this.mTunerChannelSource.setSourceEventListener(this.mConsumerSourceEventAdapter);
        this.mFrequencies = frequencies;
        this.mChannelSpecification = channelSpecification;
        this.mPreferredTuner = preferredTuner;
    }

    private void rotate() {
        if (this.mChangingChannels.compareAndSet(false, true)) {
            long frequency = this.getNextFrequency();
            if (frequency == 0L) {
                this.mChangingChannels.set(false);
                return;
            }
            if (this.mTunerChannelSource != null) {
                this.mTunerChannelSource.stop();
                this.mTunerChannelSource.setListener((Listener<ComplexSamples>)null);
                this.mTunerChannelSource.removeSourceEventListener();
                this.mTunerChannelSource.removeHeartbeatListener(this.mHeartbeatListener);
                this.mTunerChannelSource.dispose();
                this.mTunerChannelSource = null;
            }
            this.getNextSource(this.getTunerChannel(frequency));
        }
    }

    private void getNextSource(TunerChannel nextChannel) {
        if (this.mStarted) {
            Source source = this.mTunerManager.getSource(nextChannel, this.mChannelSpecification, this.mPreferredTuner);
            if (source instanceof TunerChannelSource) {
                this.mTunerChannelSource = (TunerChannelSource)source;
                this.mTunerChannelSource.setSourceEventListener(this.mConsumerSourceEventAdapter);
                this.mTunerChannelSource.setListener(this.mComplexSamplesListener);
                this.mTunerChannelSource.addHeartbeatListener(this.mHeartbeatListener);
                this.mTunerChannelSource.start();
                this.mTunerChannel = nextChannel;
                this.mChangingChannels.set(false);
                this.getSourceEventListener().receive(SourceEvent.frequencyRotationSuccessNotification(this, nextChannel.getFrequency()));
            }
            if (this.mTunerChannelSource == null) {
                this.getSourceEventListener().receive(SourceEvent.frequencyRotationFailureNotification(this, nextChannel.getFrequency()));
                ThreadPool.SCHEDULED.schedule(() -> this.getNextSource(this.getTunerChannel(this.getNextFrequency())), 500L, TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public void start() {
        if (this.mTunerChannelSource != null) {
            this.mTunerChannelSource.start();
            this.mStarted = true;
        }
    }

    @Override
    public void stop() {
        this.mStarted = false;
        if (this.mTunerChannelSource != null) {
            this.mTunerChannelSource.stop();
            this.mTunerChannelSource.removeSourceEventListener();
            this.mTunerChannelSource = null;
        }
    }

    @Subscribe
    public void process(FrequencyLockChangeRequest request) {
        if (request.isLockRequest() && !this.mLockedFrequencies.contains(request.getFrequency())) {
            this.mLockedFrequencies.add(request.getFrequency());
        } else if (request.isUnlockRequest() && this.mLockedFrequencies.contains(request.getFrequency())) {
            this.mLockedFrequencies.remove(request.getFrequency());
        }
    }

    private long getNextFrequency() {
        if (this.mFrequencies.size() <= 1) {
            return 0L;
        }
        ++this.mFrequencyListPointer;
        this.mFrequencyListPointer %= this.mFrequencies.size();
        long frequency = this.mFrequencies.get(this.mFrequencyListPointer);
        for (int attempts = 0; (this.mLockedFrequencies.contains(frequency) || frequency == this.getFrequency()) && attempts < this.mFrequencies.size(); ++attempts) {
            if (frequency == this.getFrequency()) {
                return 0L;
            }
            ++this.mFrequencyListPointer;
            this.mFrequencyListPointer %= this.mFrequencies.size();
            frequency = this.mFrequencies.get(this.mFrequencyListPointer);
        }
        return frequency;
    }

    private TunerChannel getTunerChannel(long frequency) {
        return new TunerChannel(frequency, this.mChannelSpecification.getBandwidth());
    }

    @Override
    public void addHeartbeatListener(Listener<Heartbeat> listener) {
        this.mHeartbeatListener = listener;
        if (this.mTunerChannelSource != null) {
            this.mTunerChannelSource.addHeartbeatListener(listener);
        }
    }

    @Override
    public void removeHeartbeatListener(Listener<Heartbeat> listener) {
        this.mHeartbeatListener = null;
        if (this.mTunerChannelSource != null) {
            this.mTunerChannelSource.removeHeartbeatListener(listener);
        }
    }

    @Override
    public void setFrequency(long frequency) {
        if (this.mTunerChannelSource != null) {
            this.mTunerChannelSource.setFrequency(frequency);
        }
    }

    @Override
    protected void setSampleRate(double sampleRate) {
        if (this.mTunerChannelSource != null) {
            this.mTunerChannelSource.setSampleRate(sampleRate);
        }
    }

    @Override
    public void setListener(Listener<ComplexSamples> complexSamplesListener) {
        this.mComplexSamplesListener = complexSamplesListener;
        if (this.mTunerChannelSource != null) {
            this.mTunerChannelSource.setListener(complexSamplesListener);
        }
    }

    @Override
    public double getSampleRate() {
        if (this.mTunerChannelSource != null) {
            return this.mTunerChannelSource.getSampleRate();
        }
        return 0.0;
    }

    @Override
    public void process(SourceEvent sourceEvent) throws SourceException {
        if (sourceEvent.getEvent() == SourceEvent.Event.REQUEST_FREQUENCY_ROTATION) {
            this.rotate();
        } else if (this.mTunerChannelSource != null) {
            this.mTunerChannelSource.process(sourceEvent);
        }
    }

    public class ConsumerSourceEventAdapter
    implements Listener<SourceEvent> {
        @Override
        public void receive(SourceEvent sourceEvent) {
            MultiFrequencyTunerChannelSource.this.broadcastConsumerSourceEvent(sourceEvent);
        }
    }
}

