/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.airspy.hf;

import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.airspy.hf.AirspyHfSampleRate;
import io.github.dsheirer.source.tuner.airspy.hf.AirspyHfTuner;
import io.github.dsheirer.source.tuner.airspy.hf.AirspyHfTunerConfiguration;
import io.github.dsheirer.source.tuner.airspy.hf.Attenuation;
import io.github.dsheirer.source.tuner.manager.DiscoveredTuner;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import io.github.dsheirer.source.tuner.ui.TunerEditor;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.IOException;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AirspyHfTunerEditor
extends TunerEditor<AirspyHfTuner, AirspyHfTunerConfiguration> {
    private static final Logger mLog = LoggerFactory.getLogger(AirspyHfTunerEditor.class);
    private JComboBox<AirspyHfSampleRate> mSampleRateCombo;
    private JComboBox<Attenuation> mAttenuationCombo;
    private JToggleButton mAgcToggleButton;
    private JToggleButton mLnaToggleButton;

    public AirspyHfTunerEditor(UserPreferences userPreferences, TunerManager tunerManager, DiscoveredTuner discoveredTuner) {
        super(userPreferences, tunerManager, discoveredTuner);
        this.init();
        this.tunerStatusUpdated();
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("fill,wrap 3", "[right][grow,fill][fill]", "[][][][][][][][][][][][][grow]"));
        this.add(new JLabel("Tuner:"));
        this.add((Component)this.getTunerIdLabel(), "wrap");
        this.add(new JLabel("Status:"));
        this.add((Component)this.getTunerStatusLabel(), "wrap");
        this.add((Component)this.getButtonPanel(), "span,align left");
        this.add((Component)new JSeparator(), "span,growx,push");
        this.add(new JLabel("Frequency (MHz):"));
        this.add((Component)this.getFrequencyPanel(), "wrap");
        this.add(new JLabel("Sample Rate:"));
        this.add(this.getSampleRateCombo(), "wrap");
        this.add((Component)new JSeparator(), "span");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout((LayoutManager)new MigLayout("insets 0", "[left]", ""));
        buttonPanel.add(this.getAgcToggleButton());
        buttonPanel.add(this.getLnaToggleButton());
        this.add(new JLabel(" "));
        this.add((Component)buttonPanel, "wrap");
        this.add(new JLabel("Attenuation:"));
        this.add(this.getAttenuationCombo(), "wrap");
    }

    @Override
    protected void save() {
        if (this.hasConfiguration() && !this.isLoading()) {
            ((AirspyHfTunerConfiguration)this.getConfiguration()).setFrequency(this.getFrequencyControl().getFrequency());
            double value = ((SpinnerNumberModel)this.getFrequencyCorrectionSpinner().getModel()).getNumber().doubleValue();
            ((AirspyHfTunerConfiguration)this.getConfiguration()).setFrequencyCorrection(value);
            ((AirspyHfTunerConfiguration)this.getConfiguration()).setAutoPPMCorrectionEnabled(this.getAutoPPMCheckBox().isSelected());
            ((AirspyHfTunerConfiguration)this.getConfiguration()).setSampleRate((int)((AirspyHfTuner)this.getTuner()).getController().getSampleRate());
            Attenuation attenuation = (Attenuation)((Object)this.getAttenuationCombo().getSelectedItem());
            ((AirspyHfTunerConfiguration)this.getConfiguration()).setAttenuation(attenuation);
            ((AirspyHfTunerConfiguration)this.getConfiguration()).setAgc(this.getAgcToggleButton().isSelected());
            ((AirspyHfTunerConfiguration)this.getConfiguration()).setLna(this.getLnaToggleButton().isSelected());
            this.saveConfiguration();
        }
    }

    @Override
    protected void tunerStatusUpdated() {
        this.setLoading(true);
        Object status = this.getDiscoveredTuner().getTunerStatus().toString();
        if (this.getDiscoveredTuner().hasErrorMessage()) {
            status = (String)status + " - " + this.getDiscoveredTuner().getErrorMessage();
        }
        this.getTunerStatusLabel().setText((String)status);
        this.getButtonPanel().updateControls();
        this.getFrequencyPanel().updateControls();
        if (this.hasTuner()) {
            this.getTunerIdLabel().setText("Airspy " + String.valueOf((Object)((AirspyHfTuner)this.getTuner()).getController().getBoardId()) + " SER# " + ((AirspyHfTuner)this.getTuner()).getController().getSerialNumber());
            this.getSampleRateCombo().setEnabled(false);
            this.getSampleRateCombo().removeAllItems();
            for (AirspyHfSampleRate sampleRate : ((AirspyHfTuner)this.getTuner()).getController().getAvailableSampleRates()) {
                this.getSampleRateCombo().addItem(sampleRate);
            }
            this.getAgcToggleButton().setEnabled(true);
            this.getAgcToggleButton().setSelected(((AirspyHfTuner)this.getTuner()).getController().getAgc());
            this.getLnaToggleButton().setEnabled(true);
            this.getLnaToggleButton().setSelected(((AirspyHfTuner)this.getTuner()).getController().getLna());
            this.getSampleRateCombo().setSelectedItem(((AirspyHfTuner)this.getTuner()).getController().getCurrentAirspySampleRate());
            this.getAttenuationCombo().setEnabled(true);
            this.getAttenuationCombo().setSelectedItem((Object)((AirspyHfTuner)this.getTuner()).getController().getAttenuation());
        } else {
            this.getTunerIdLabel().setText("Airspy HF+");
            this.getAgcToggleButton().setEnabled(false);
            this.getAgcToggleButton().setSelected(false);
            this.getLnaToggleButton().setEnabled(false);
            this.getLnaToggleButton().setSelected(false);
            this.getSampleRateCombo().setEnabled(false);
            this.getAttenuationCombo().setEnabled(false);
            this.getAttenuationCombo().setSelectedItem((Object)Attenuation.A0);
        }
        this.updateSampleRateToolTip();
        this.setLoading(false);
    }

    private void updateSampleRateToolTip() {
        if (this.hasTuner() && ((AirspyHfTuner)this.getTuner()).getTunerController().isLockedSampleRate()) {
            this.getSampleRateCombo().setToolTipText("Sample Rate is locked.  Disable decoding channels to unlock.");
        } else if (this.hasTuner()) {
            this.getSampleRateCombo().setToolTipText("Select a sample rate for the tuner");
        } else {
            this.getSampleRateCombo().setToolTipText("No tuner available");
        }
    }

    @Override
    public void setTunerLockState(boolean locked) {
        this.getFrequencyPanel().updateControls();
        this.getSampleRateCombo().setEnabled(!locked);
        this.updateSampleRateToolTip();
    }

    private JComboBox<AirspyHfSampleRate> getSampleRateCombo() {
        if (this.mSampleRateCombo == null) {
            this.mSampleRateCombo = new JComboBox();
            this.mSampleRateCombo.setEnabled(false);
            this.mSampleRateCombo.addActionListener(e -> {
                AirspyHfSampleRate sampleRate;
                if (!this.isLoading() && (sampleRate = (AirspyHfSampleRate)this.mSampleRateCombo.getSelectedItem()) != null) {
                    try {
                        ((AirspyHfTuner)this.getTuner()).getController().setSampleRate(sampleRate);
                        this.save();
                    }
                    catch (SourceException se) {
                        mLog.error("Error setting Airspy Hf Sample Rate [" + String.valueOf(sampleRate) + "]", (Throwable)se);
                        JOptionPane.showMessageDialog(this, "Airspy Tuner Controller - couldn't apply the sample rate setting [" + String.valueOf(sampleRate) + "] " + se.getLocalizedMessage());
                    }
                }
            });
        }
        return this.mSampleRateCombo;
    }

    private JComboBox<Attenuation> getAttenuationCombo() {
        if (this.mAttenuationCombo == null) {
            this.mAttenuationCombo = new JComboBox<Attenuation>(Attenuation.values());
            this.mAttenuationCombo.setEnabled(false);
            this.mAttenuationCombo.addActionListener(e -> {
                if (!this.isLoading()) {
                    Attenuation selected = (Attenuation)((Object)((Object)this.mAttenuationCombo.getSelectedItem()));
                    try {
                        ((AirspyHfTuner)this.getTuner()).getController().setAttenuation(selected);
                        this.save();
                    }
                    catch (IOException ioe) {
                        mLog.error("Error setting Airspy Hf attenuation [" + String.valueOf((Object)selected) + "]", (Throwable)ioe);
                        JOptionPane.showMessageDialog(this, "Airspy Tuner Controller - couldn't apply attenuation setting [" + String.valueOf((Object)selected) + "] " + ioe.getLocalizedMessage());
                    }
                }
            });
        }
        return this.mAttenuationCombo;
    }

    private JToggleButton getAgcToggleButton() {
        if (this.mAgcToggleButton == null) {
            this.mAgcToggleButton = new JToggleButton("AGC");
            this.mAgcToggleButton.setToolTipText("Automatic Gain Control");
            this.mAgcToggleButton.setEnabled(false);
            this.mAgcToggleButton.addActionListener(e -> {
                if (!this.isLoading()) {
                    try {
                        ((AirspyHfTuner)this.getTuner()).getController().setAgc(this.mAgcToggleButton.isSelected());
                        this.save();
                    }
                    catch (IOException ioe) {
                        mLog.error("Error setting Airspy HF AGC", (Throwable)ioe);
                        JOptionPane.showMessageDialog(this, "Airspy HF Tuner Controller - couldn't change AGC setting" + ioe.getLocalizedMessage());
                    }
                }
            });
        }
        return this.mAgcToggleButton;
    }

    private JToggleButton getLnaToggleButton() {
        if (this.mLnaToggleButton == null) {
            this.mLnaToggleButton = new JToggleButton("LNA");
            this.mLnaToggleButton.setToolTipText("Low Noise Amplifier");
            this.mLnaToggleButton.setEnabled(false);
            this.mLnaToggleButton.addActionListener(e -> {
                if (!this.isLoading()) {
                    try {
                        ((AirspyHfTuner)this.getTuner()).getController().setLna(this.mLnaToggleButton.isSelected());
                        this.save();
                    }
                    catch (IOException ioe) {
                        mLog.error("Error setting Airspy HF LNA", (Throwable)ioe);
                        JOptionPane.showMessageDialog(this, "Airspy HF Tuner Controller - couldn't change LNA setting" + ioe.getLocalizedMessage());
                    }
                }
            });
        }
        return this.mLnaToggleButton;
    }
}

