/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.airspy;

import io.github.dsheirer.preference.source.ChannelizerType;
import io.github.dsheirer.source.tuner.ITunerErrorListener;
import io.github.dsheirer.source.tuner.Tuner;
import io.github.dsheirer.source.tuner.TunerClass;
import io.github.dsheirer.source.tuner.airspy.AirspyTunerController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AirspyTuner
extends Tuner {
    private static final Logger mLog = LoggerFactory.getLogger(AirspyTuner.class);

    public AirspyTuner(AirspyTunerController controller, ITunerErrorListener tunerErrorListener, ChannelizerType channelizerType) {
        super(controller, tunerErrorListener, channelizerType);
    }

    @Override
    public String getPreferredName() {
        return "Airspy " + this.getController().getDeviceInfo().getSerialNumber();
    }

    public AirspyTunerController getController() {
        return (AirspyTunerController)this.getTunerController();
    }

    @Override
    public String getUniqueID() {
        try {
            return this.getController().getDeviceInfo().getSerialNumber();
        }
        catch (Exception e) {
            mLog.error("error getting serial number", (Throwable)e);
            return AirspyTunerController.BoardID.AIRSPY.getLabel();
        }
    }

    @Override
    public TunerClass getTunerClass() {
        return TunerClass.AIRSPY;
    }

    @Override
    public double getSampleSize() {
        return 13.0;
    }

    @Override
    public int getMaximumUSBBitsPerSecond() {
        return 320000000;
    }
}

