/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner;

import java.util.EnumSet;

public enum TunerType {
    AIRSPY_R820T("R820T"),
    AIRSPY_HF_PLUS("HF+"),
    ELONICS_E4000("E4000"),
    FCI_FC2580("FC2580"),
    FITIPOWER_FC0012("FC0012"),
    FITIPOWER_FC0013("FC0013"),
    FUNCUBE_DONGLE_PRO("Funcube Dongle Pro"),
    FUNCUBE_DONGLE_PRO_PLUS("Funcube Dongle Pro Plus"),
    HACKRF_ONE("ONE"),
    HACKRF_JAWBREAKER("Jawbreaker"),
    HACKRF_RAD1O("RAD1O"),
    RAFAELMICRO_R820T("R820T"),
    RAFAELMICRO_R828D("R828D"),
    RSP_1("RSP1"),
    RSP_1A("RSP1A"),
    RSP_2("RSP2"),
    RSP_DUO_1("RSPduo Tuner 1"),
    RSP_DUO_2("RSPduo Tuner 2"),
    RSP_DX("RSPdx"),
    TEST("Test"),
    RECORDING("Recording"),
    UNKNOWN("Unknown");

    private String mLabel;
    public static EnumSet<TunerType> SUPPORTED_USB_TUNERS;
    public static EnumSet<TunerType> SUPPORTED_SOUND_CARD_TUNERS;

    private TunerType(String label) {
        this.mLabel = label;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public boolean isSupportedUsbTuner() {
        return SUPPORTED_USB_TUNERS.contains((Object)this);
    }

    public boolean isSupportedSoundCardTuner() {
        return SUPPORTED_SOUND_CARD_TUNERS.contains((Object)this);
    }

    public String toString() {
        return this.getLabel();
    }

    static {
        SUPPORTED_USB_TUNERS = EnumSet.of(AIRSPY_R820T, new TunerType[]{ELONICS_E4000, FITIPOWER_FC0012, HACKRF_JAWBREAKER, HACKRF_RAD1O, HACKRF_ONE, RAFAELMICRO_R820T});
        SUPPORTED_SOUND_CARD_TUNERS = EnumSet.of(FUNCUBE_DONGLE_PRO, FUNCUBE_DONGLE_PRO_PLUS);
    }
}

