/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner;

import io.github.dsheirer.preference.source.ChannelizerType;
import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.ISourceEventProcessor;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.ITunerErrorListener;
import io.github.dsheirer.source.tuner.TunerClass;
import io.github.dsheirer.source.tuner.TunerController;
import io.github.dsheirer.source.tuner.TunerEvent;
import io.github.dsheirer.source.tuner.TunerFrequencyErrorMonitor;
import io.github.dsheirer.source.tuner.TunerType;
import io.github.dsheirer.source.tuner.manager.ChannelSourceManager;
import io.github.dsheirer.source.tuner.manager.HeterodyneChannelSourceManager;
import io.github.dsheirer.source.tuner.manager.PolyphaseChannelSourceManager;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Tuner
implements ISourceEventProcessor,
ITunerErrorListener {
    private static final Logger mLog = LoggerFactory.getLogger(Tuner.class);
    private Broadcaster<TunerEvent> mTunerEventBroadcaster = new Broadcaster();
    private ChannelSourceManager mChannelSourceManager;
    private TunerController mTunerController;
    private TunerFrequencyErrorMonitor mTunerFrequencyErrorMonitor;
    private ITunerErrorListener mTunerErrorListener;
    private AtomicBoolean mRunning = new AtomicBoolean();

    public Tuner(TunerController tunerController, ITunerErrorListener tunerErrorListener) {
        this.mTunerController = tunerController;
        this.mTunerErrorListener = tunerErrorListener;
        this.mTunerController.addListener(this::process);
        this.mTunerFrequencyErrorMonitor = new TunerFrequencyErrorMonitor(this);
        this.mTunerFrequencyErrorMonitor.start();
    }

    public Tuner(TunerController tunerController, ITunerErrorListener tunerErrorListener, ChannelizerType channelizerType) {
        this(tunerController, tunerErrorListener);
        if (channelizerType == ChannelizerType.POLYPHASE) {
            this.setChannelSourceManager(new PolyphaseChannelSourceManager(this.mTunerController));
        } else if (channelizerType == ChannelizerType.HETERODYNE) {
            this.setChannelSourceManager(new HeterodyneChannelSourceManager(this.mTunerController));
        } else {
            throw new IllegalArgumentException("Unrecognized channelizer type: " + String.valueOf((Object)channelizerType));
        }
    }

    public void start() throws SourceException {
        if (this.mRunning.compareAndSet(false, true)) {
            try {
                this.getTunerController().start();
            }
            catch (SourceException se) {
                this.mRunning.set(false);
                throw se;
            }
            catch (Exception e) {
                this.mRunning.set(false);
                mLog.error("Error starting " + String.valueOf((Object)this.getTunerClass()) + " tuner", (Throwable)e);
                throw new SourceException("Unable to start " + String.valueOf((Object)this.getTunerClass()) + " tuner", e);
            }
        }
    }

    public void stop() {
        if (this.mRunning.compareAndSet(true, false)) {
            this.broadcast(new TunerEvent(this, TunerEvent.Event.NOTIFICATION_SHUTTING_DOWN));
            if (this.getChannelSourceManager() != null) {
                this.getChannelSourceManager().stopAllChannels();
                this.getChannelSourceManager().dispose();
                this.mChannelSourceManager = null;
            }
            this.getTunerController().stop();
            this.getTunerController().dispose();
            this.mTunerEventBroadcaster.clear();
            this.mTunerFrequencyErrorMonitor = null;
            this.mTunerErrorListener = null;
        }
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        this.broadcast(new TunerEvent(this, TunerEvent.Event.NOTIFICATION_ERROR_STATE));
        if (this.mTunerErrorListener != null) {
            this.mTunerErrorListener.setErrorMessage(errorMessage);
        }
    }

    @Override
    public void tunerRemoved() {
        this.stop();
        if (this.mTunerErrorListener != null) {
            this.mTunerErrorListener.tunerRemoved();
        }
    }

    protected void setChannelSourceManager(ChannelSourceManager manager) {
        this.mChannelSourceManager = manager;
        this.mChannelSourceManager.addSourceEventListener(this::process);
    }

    public abstract int getMaximumUSBBitsPerSecond();

    @Override
    public void process(SourceEvent event) {
        switch (event.getEvent()) {
            case NOTIFICATION_CHANNEL_COUNT_CHANGE: {
                this.broadcast(new TunerEvent(this, TunerEvent.Event.UPDATE_CHANNEL_COUNT));
                break;
            }
            case NOTIFICATION_FREQUENCY_CHANGE: {
                this.broadcast(new TunerEvent(this, TunerEvent.Event.UPDATE_FREQUENCY));
                break;
            }
            case NOTIFICATION_FREQUENCY_CORRECTION_CHANGE: {
                this.broadcast(new TunerEvent(this, TunerEvent.Event.UPDATE_FREQUENCY_ERROR));
                break;
            }
            case NOTIFICATION_SAMPLE_RATE_CHANGE: {
                this.broadcast(new TunerEvent(this, TunerEvent.Event.UPDATE_SAMPLE_RATE));
                break;
            }
            case NOTIFICATION_FREQUENCY_AND_SAMPLE_RATE_LOCKED: 
            case NOTIFICATION_FREQUENCY_AND_SAMPLE_RATE_UNLOCKED: {
                this.broadcast(new TunerEvent(this, TunerEvent.Event.UPDATE_LOCK_STATE));
                break;
            }
            case NOTIFICATION_MEASURED_FREQUENCY_ERROR_SYNC_LOCKED: {
                this.mTunerFrequencyErrorMonitor.receive(event);
                break;
            }
            case NOTIFICATION_RECORDING_FILE_LOADED: {
                break;
            }
            default: {
                mLog.debug("Unrecognized Source Event: " + String.valueOf(event));
            }
        }
    }

    public ChannelSourceManager getChannelSourceManager() {
        return this.mChannelSourceManager;
    }

    public TunerController getTunerController() {
        return this.mTunerController;
    }

    public String toString() {
        return this.getPreferredName();
    }

    public abstract String getUniqueID();

    public abstract TunerClass getTunerClass();

    public TunerType getTunerType() {
        return this.getTunerController().getTunerType();
    }

    public abstract String getPreferredName();

    public abstract double getSampleSize();

    public void addTunerEventListener(Listener<TunerEvent> listener) {
        this.mTunerEventBroadcaster.addListener(listener);
    }

    public void removeTunerEventListener(Listener<TunerEvent> listener) {
        this.mTunerEventBroadcaster.removeListener(listener);
    }

    protected void broadcast(TunerEvent tunerEvent) {
        this.mTunerEventBroadcaster.broadcast(tunerEvent);
    }
}

