/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner;

import io.github.dsheirer.source.tuner.TunerType;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Mixer;

public enum MixerTunerType {
    FUNCUBE_DONGLE_PRO(TunerType.FUNCUBE_DONGLE_PRO, "V10", "FUNcube Dongle", "FUNcube Dongle Pro V1.0", new AudioFormat(96000.0f, 16, 2, true, false)),
    FUNCUBE_DONGLE_PRO_PLUS(TunerType.FUNCUBE_DONGLE_PRO_PLUS, "V20", "FUNcube Dongle V2.0", "FUNcube Dongle Pro Plus V2.0", new AudioFormat(192000.0f, 16, 2, true, false)),
    UNKNOWN(TunerType.UNKNOWN, "UNK", "Unknown", "Unknown Mixer Tuner", new AudioFormat(48000.0f, 16, 2, true, false));

    private TunerType mTunerType;
    private String mMixerName;
    private String mPartialDescription;
    private String mDisplayString;
    private AudioFormat mAudioFormat;

    private MixerTunerType(TunerType tunerType, String mixerName, String partialDescription, String displayString, AudioFormat format) {
        this.mTunerType = tunerType;
        this.mMixerName = mixerName;
        this.mPartialDescription = partialDescription;
        this.mDisplayString = displayString;
        this.mAudioFormat = format;
    }

    public TunerType getTunerType() {
        return this.mTunerType;
    }

    public String getMixerName() {
        return this.mMixerName;
    }

    public String getPartialDescription() {
        return this.mPartialDescription;
    }

    public String getDisplayString() {
        return this.mDisplayString;
    }

    public AudioFormat getAudioFormat() {
        return this.mAudioFormat;
    }

    public static MixerTunerType getMixerTunerType(Mixer.Info info) {
        MixerTunerType retVal = UNKNOWN;
        if (info.getName().contains(MixerTunerType.FUNCUBE_DONGLE_PRO_PLUS.mPartialDescription) || info.getDescription().contains(MixerTunerType.FUNCUBE_DONGLE_PRO_PLUS.mPartialDescription)) {
            retVal = FUNCUBE_DONGLE_PRO_PLUS;
        } else if (info.getName().contains(MixerTunerType.FUNCUBE_DONGLE_PRO.mPartialDescription) || info.getDescription().contains(MixerTunerType.FUNCUBE_DONGLE_PRO.mPartialDescription)) {
            retVal = FUNCUBE_DONGLE_PRO;
        }
        return retVal;
    }
}

