/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.mixer;

import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.adapter.ISampleAdapter;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.heartbeat.HeartbeatManager;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixerReader<T> {
    private static final Logger mLog = LoggerFactory.getLogger(MixerReader.class);
    private TargetDataLine mTargetDataLine;
    private int mBufferSize;
    private AtomicBoolean mRunning = new AtomicBoolean();
    private ISampleAdapter<T> mSampleAdapter;
    private Listener<T> mListener;
    private Listener<SourceEvent> mSourceEventListener;
    private AudioFormat mAudioFormat;
    private HeartbeatManager mHeartbeatManager;
    private Thread mReaderThread;

    public MixerReader(AudioFormat audioFormat, TargetDataLine targetDataLine, ISampleAdapter<T> abstractSampleAdapter, HeartbeatManager heartbeatManager) {
        this.mTargetDataLine = targetDataLine;
        this.mAudioFormat = audioFormat;
        this.mSampleAdapter = abstractSampleAdapter;
        this.mHeartbeatManager = heartbeatManager;
        if (this.mAudioFormat.getSampleRate() <= 96000.0f) {
            this.setBufferSampleSize(4096);
        } else {
            this.setBufferSampleSize(8192);
        }
    }

    public MixerReader(AudioFormat audioFormat, TargetDataLine targetDataLine, ISampleAdapter<T> abstractSampleAdapter) {
        this(audioFormat, targetDataLine, abstractSampleAdapter, new HeartbeatManager());
    }

    public AudioFormat getAudioFormat() {
        return this.mAudioFormat;
    }

    public void setBufferSampleSize(int samples) {
        this.mBufferSize = samples * this.mAudioFormat.getFrameSize();
    }

    public void start() {
        if (this.mRunning.compareAndSet(false, true)) {
            if (this.mTargetDataLine == null) {
                this.mRunning.set(false);
                mLog.error("Attempt to start failed - target data line is null");
                return;
            }
            try {
                this.mTargetDataLine.open(this.getAudioFormat());
                this.mTargetDataLine.start();
            }
            catch (LineUnavailableException e) {
                mLog.error("Unable to open mixer source target data line", (Throwable)e);
                this.mRunning.set(false);
                return;
            }
            this.mReaderThread = new Thread(new DataLineReader());
            this.mReaderThread.setName("sdrtrunk mixer sample reader");
            this.mReaderThread.start();
        } else {
            mLog.warn("Attempt to start an already running BufferReader instance - this shouldn't happen");
        }
    }

    public void stop() {
        if (this.mRunning.compareAndSet(true, false)) {
            if (this.mTargetDataLine != null && this.mTargetDataLine.isOpen()) {
                if (this.mTargetDataLine.isRunning()) {
                    this.mTargetDataLine.stop();
                }
                if (this.mTargetDataLine.isOpen()) {
                    this.mTargetDataLine.close();
                }
            }
            this.mReaderThread.interrupt();
            try {
                this.mReaderThread.join(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mReaderThread = null;
        }
    }

    public boolean isRunning() {
        return this.mRunning.get();
    }

    public void setBufferListener(Listener<T> listener) {
        this.mListener = listener;
    }

    public void removeBufferListener() {
        this.mListener = null;
    }

    public void setSourceEventListener(Listener<SourceEvent> listener) {
        this.mSourceEventListener = listener;
    }

    public void removeSourceEventListener() {
        this.mSourceEventListener = null;
    }

    public Listener<SourceEvent> getSourceEventListener() {
        return this.mSourceEventListener;
    }

    public double getSampleRate() {
        return this.mAudioFormat.getSampleRate();
    }

    public void dispose() {
        this.mHeartbeatManager = null;
        this.mListener = null;
        this.mSourceEventListener = null;
    }

    public class DataLineReader
    implements Runnable {
        @Override
        public void run() {
            while (MixerReader.this.mRunning.get()) {
                int bytesRead;
                if (MixerReader.this.mHeartbeatManager != null) {
                    MixerReader.this.mHeartbeatManager.broadcast();
                }
                byte[] buffer = new byte[MixerReader.this.mBufferSize];
                try {
                    for (bytesRead = 0; bytesRead < buffer.length; bytesRead += MixerReader.this.mTargetDataLine.read(buffer, bytesRead, buffer.length)) {
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                if (bytesRead != buffer.length || MixerReader.this.mListener == null) continue;
                MixerReader.this.mListener.receive(MixerReader.this.mSampleAdapter.convert(buffer));
            }
        }
    }
}

