/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.mixer;

import io.github.dsheirer.source.mixer.MixerChannel;
import javax.sound.sampled.Mixer;

public class MixerChannelConfiguration {
    private Mixer mMixer;
    private MixerChannel mMixerChannel;

    public MixerChannelConfiguration(Mixer mixer, MixerChannel channel) {
        this.mMixer = mixer;
        this.mMixerChannel = channel;
    }

    public Mixer getMixer() {
        return this.mMixer;
    }

    public MixerChannel getMixerChannel() {
        return this.mMixerChannel;
    }

    public boolean matches(String mixer, String channels) {
        return mixer != null && channels != null && this.mMixer.getMixerInfo().getName().contentEquals(mixer) && this.mMixerChannel.name().contentEquals(channels);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mMixer.getMixerInfo().getName());
        sb.append(" - ");
        sb.append(this.mMixerChannel.name());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mMixer == null ? 0 : this.mMixer.hashCode());
        result = 31 * result + (this.mMixerChannel == null ? 0 : this.mMixerChannel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MixerChannelConfiguration other = (MixerChannelConfiguration)obj;
        if (this.mMixer == null ? other.mMixer != null : !this.mMixer.equals(other.mMixer)) {
            return false;
        }
        return this.mMixerChannel == other.mMixerChannel;
    }
}

