/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.source.SourceType;
import io.github.dsheirer.source.config.SourceConfiguration;
import io.github.dsheirer.source.tuner.channel.TunerChannel;
import java.text.DecimalFormat;

@JsonSubTypes.Type(value=SourceConfigTuner.class, name="sourceConfigTuner")
public class SourceConfigTuner
extends SourceConfiguration {
    private static DecimalFormat FREQUENCY_FORMAT = new DecimalFormat("0.00000");
    private long mFrequency = 0L;
    private String mPreferredTuner;

    public SourceConfigTuner() {
        super(SourceType.TUNER);
    }

    public SourceConfigTuner(TunerChannel tunerChannel) {
        this();
        this.mFrequency = tunerChannel.getFrequency();
    }

    @JacksonXmlProperty(isAttribute=true, localName="frequency")
    public long getFrequency() {
        return this.mFrequency;
    }

    public void setFrequency(long frequency) {
        this.mFrequency = frequency;
    }

    @JacksonXmlProperty(isAttribute=true, localName="preferred_tuner")
    public String getPreferredTuner() {
        return this.mPreferredTuner;
    }

    @JsonIgnore
    public boolean hasPreferredTuner() {
        return this.mPreferredTuner != null;
    }

    public void setPreferredTuner(String preferredTuner) {
        this.mPreferredTuner = preferredTuner;
    }

    @Override
    @JsonIgnore
    public String getDescription() {
        return FREQUENCY_FORMAT.format((double)this.mFrequency / 1000000.0) + (String)(this.mPreferredTuner != null ? "MHz PREFERRED TUNER:" + this.mPreferredTuner : "MHz");
    }

    @JsonIgnore
    public TunerChannel getTunerChannel(int bandwidth) {
        return new TunerChannel(this.mFrequency, bandwidth);
    }

    public String toString() {
        return this.getDescription();
    }
}

