/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.config;

import io.github.dsheirer.source.SourceType;
import io.github.dsheirer.source.config.SourceConfigMixer;
import io.github.dsheirer.source.config.SourceConfigNone;
import io.github.dsheirer.source.config.SourceConfigRecording;
import io.github.dsheirer.source.config.SourceConfigTuner;
import io.github.dsheirer.source.config.SourceConfigTunerMultipleFrequency;
import io.github.dsheirer.source.config.SourceConfiguration;

public class SourceConfigFactory {
    public static SourceConfiguration getDefaultSourceConfiguration() {
        return SourceConfigFactory.getSourceConfiguration(SourceType.TUNER);
    }

    public static SourceConfiguration getSourceConfiguration(SourceType source) {
        return switch (source) {
            case SourceType.TUNER -> new SourceConfigTuner();
            case SourceType.TUNER_MULTIPLE_FREQUENCIES -> new SourceConfigTunerMultipleFrequency();
            case SourceType.MIXER -> new SourceConfigMixer();
            default -> new SourceConfigNone();
        };
    }

    public static SourceConfiguration copy(SourceConfiguration config) {
        if (config != null) {
            switch (config.getSourceType()) {
                case MIXER: {
                    SourceConfigMixer originalMixer = (SourceConfigMixer)config;
                    SourceConfigMixer copyMixer = new SourceConfigMixer();
                    copyMixer.setChannel(originalMixer.getChannel());
                    copyMixer.setMixer(originalMixer.getMixer());
                    return copyMixer;
                }
                case RECORDING: {
                    SourceConfigRecording originalRec = (SourceConfigRecording)config;
                    SourceConfigRecording copyRec = new SourceConfigRecording();
                    copyRec.setFrequency(originalRec.getFrequency());
                    copyRec.setRecordingAlias(originalRec.getRecordingAlias());
                    return copyRec;
                }
                case TUNER: {
                    SourceConfigTuner originalTuner = (SourceConfigTuner)config;
                    SourceConfigTuner copyTuner = new SourceConfigTuner();
                    copyTuner.setPreferredTuner(originalTuner.getPreferredTuner());
                    copyTuner.setFrequency(originalTuner.getFrequency());
                    return copyTuner;
                }
                case TUNER_MULTIPLE_FREQUENCIES: {
                    SourceConfigTunerMultipleFrequency originalMulti = (SourceConfigTunerMultipleFrequency)config;
                    SourceConfigTunerMultipleFrequency copyMulti = new SourceConfigTunerMultipleFrequency();
                    copyMulti.setPreferredTuner(originalMulti.getPreferredTuner());
                    copyMulti.setFrequencies(originalMulti.getFrequencies());
                    return copyMulti;
                }
            }
            return new SourceConfigNone();
        }
        return null;
    }
}

