/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source;

import io.github.dsheirer.source.Source;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceEvent {
    private static final Logger mLog = LoggerFactory.getLogger(SourceEvent.class);
    private Event mEvent;
    private Number mValue;
    private Source mSource;
    private String mEventDescription;

    private SourceEvent(Event event, Source source, Number value, String eventDescription) {
        this.mEvent = event;
        this.mSource = source;
        this.mValue = value;
        this.mEventDescription = eventDescription;
    }

    private SourceEvent(Event event, Source source, String eventDescription) {
        this(event, source, null, eventDescription);
    }

    private SourceEvent(Event event) {
        this(event, null, null, null);
    }

    private SourceEvent(Event event, Number value, String eventDescription) {
        this(event, null, value, eventDescription);
    }

    private SourceEvent(Event event, Number value) {
        this(event, value, null);
    }

    private SourceEvent(Event event, Source source) {
        this(event, source, 0);
    }

    private SourceEvent(Event event, Source source, Number value) {
        this(event, source, value, null);
    }

    public Event getEvent() {
        return this.mEvent;
    }

    public boolean isNotificationEvent() {
        return Event.NOTIFICATION_EVENTS.contains((Object)this.mEvent);
    }

    public boolean isRequestEvent() {
        return Event.REQUEST_EVENTS.contains((Object)this.mEvent);
    }

    public Number getValue() {
        return this.mValue;
    }

    public boolean hasValue() {
        return this.mValue != null;
    }

    public Source getSource() {
        return this.mSource;
    }

    public void setSource(Source source) {
        this.mSource = source;
    }

    public boolean hasSource() {
        return this.mSource != null;
    }

    public static SourceEvent errorState(Source source, String errorDescription) {
        return new SourceEvent(Event.NOTIFICATION_ERROR_STATE, source, errorDescription);
    }

    public static SourceEvent lockedSampleRateState() {
        return new SourceEvent(Event.NOTIFICATION_FREQUENCY_AND_SAMPLE_RATE_LOCKED, 1);
    }

    public static SourceEvent unlockedSampleRateState() {
        return new SourceEvent(Event.NOTIFICATION_FREQUENCY_AND_SAMPLE_RATE_UNLOCKED, 0);
    }

    public static SourceEvent frequencyChange(Source source, long frequency) {
        return new SourceEvent(Event.NOTIFICATION_FREQUENCY_CHANGE, source, frequency);
    }

    public static SourceEvent frequencyChange(Source source, long frequency, String eventDescription) {
        return new SourceEvent(Event.NOTIFICATION_FREQUENCY_CHANGE, source, frequency, eventDescription);
    }

    public static SourceEvent frequencyCorrectionChange(long frequencyCorrection) {
        return new SourceEvent(Event.NOTIFICATION_FREQUENCY_CORRECTION_CHANGE, frequencyCorrection);
    }

    public static SourceEvent pllFrequencyMeasurement(long frequencyError) {
        return new SourceEvent(Event.NOTIFICATION_PLL_FREQUENCY, frequencyError);
    }

    public static SourceEvent frequencyErrorMeasurement(long frequencyError) {
        return new SourceEvent(Event.NOTIFICATION_MEASURED_FREQUENCY_ERROR, frequencyError);
    }

    public static SourceEvent frequencyErrorMeasurementSyncLocked(long frequencyError, String eventDescription) {
        return new SourceEvent(Event.NOTIFICATION_MEASURED_FREQUENCY_ERROR_SYNC_LOCKED, frequencyError, eventDescription);
    }

    public static SourceEvent sampleRateChange(double sampleRate) {
        return new SourceEvent(Event.NOTIFICATION_SAMPLE_RATE_CHANGE, sampleRate);
    }

    public static SourceEvent sampleRateChange(double sampleRate, String eventDescription) {
        return new SourceEvent(Event.NOTIFICATION_SAMPLE_RATE_CHANGE, sampleRate, eventDescription);
    }

    public static SourceEvent channelSampleRateChange(double sampleRate) {
        return new SourceEvent(Event.NOTIFICATION_CHANNEL_SAMPLE_RATE_CHANGE, sampleRate);
    }

    public static SourceEvent recordingFileLoaded() {
        return new SourceEvent(Event.NOTIFICATION_RECORDING_FILE_LOADED);
    }

    public static SourceEvent channelCountChange(int channelCount) {
        return new SourceEvent(Event.NOTIFICATION_CHANNEL_COUNT_CHANGE, channelCount);
    }

    public static SourceEvent frequencyRequest(long frequency) {
        return new SourceEvent(Event.REQUEST_FREQUENCY_CHANGE, frequency);
    }

    public static SourceEvent startSampleStreamRequest(Source source) {
        return SourceEvent.startSampleStreamRequest(source, System.currentTimeMillis());
    }

    public static SourceEvent startSampleStreamRequest(Source source, long timestamp) {
        return new SourceEvent(Event.REQUEST_START_SAMPLE_STREAM, source, timestamp);
    }

    public static SourceEvent stopSampleStreamRequest(Source source) {
        return new SourceEvent(Event.REQUEST_STOP_SAMPLE_STREAM, source);
    }

    public static SourceEvent stopSampleStreamNotification(Source source) {
        return new SourceEvent(Event.NOTIFICATION_STOP_SAMPLE_STREAM, source);
    }

    public static SourceEvent frequencyRotationRequest() {
        return new SourceEvent(Event.REQUEST_FREQUENCY_ROTATION);
    }

    public static SourceEvent frequencySelectionRequest() {
        return new SourceEvent(Event.REQUEST_FREQUENCY_SELECTION);
    }

    public static SourceEvent frequencyRotationSuccessNotification(Source source, long frequency) {
        return new SourceEvent(Event.NOTIFICATION_FREQUENCY_ROTATION_SUCCESS, source, frequency);
    }

    public static SourceEvent frequencyRotationFailureNotification(Source source, long frequency) {
        return new SourceEvent(Event.NOTIFICATION_FREQUENCY_ROTATION_FAILURE, source, frequency);
    }

    public static SourceEvent channelPowerLevel(Source source, double powerDb) {
        return new SourceEvent(Event.NOTIFICATION_CHANNEL_POWER, source, powerDb);
    }

    public static SourceEvent squelchThreshold(Source source, double thresholdDb) {
        return new SourceEvent(Event.NOTIFICATION_SQUELCH_THRESHOLD, source, thresholdDb);
    }

    public static SourceEvent requestCurrentSquelchThreshold() {
        return new SourceEvent(Event.REQUEST_CURRENT_SQUELCH_THRESHOLD, null, 0);
    }

    public static SourceEvent requestSquelchThreshold(Source source, double thresholdDb) {
        return new SourceEvent(Event.REQUEST_CHANGE_SQUELCH_THRESHOLD, source, thresholdDb);
    }

    public static SourceEvent requestCurrentSquelchAutoTrack() {
        return new SourceEvent(Event.REQUEST_CURRENT_SQUELCH_AUTO_TRACK, null, 0);
    }

    public static SourceEvent squelchAutoTrack(boolean autoTrack) {
        return new SourceEvent(Event.NOTIFICATION_SQUELCH_AUTO_TRACK, null, autoTrack ? 1 : 0);
    }

    public static SourceEvent requestSquelchAutoTrack(boolean autoTrack) {
        return new SourceEvent(Event.REQUEST_CHANGE_SQUELCH_AUTO_TRACK, null, autoTrack ? 1 : 0);
    }

    public String toString() {
        return "SOURCE EVENT:" + String.valueOf((Object)this.mEvent) + " VALUE:" + String.valueOf(this.mValue != null ? this.mValue : "(empty)") + " SOURCE:" + (this.mSource != null ? this.mSource.toString() : "(null)") + " DESCRIPTION:" + (this.mEventDescription != null ? this.mEventDescription : "");
    }

    public static enum Event {
        NOTIFICATION_CHANNEL_COUNT_CHANGE,
        NOTIFICATION_CHANNEL_FREQUENCY_CORRECTION,
        NOTIFICATION_CHANNEL_FREQUENCY_CORRECTION_CHANGE,
        NOTIFICATION_CHANNEL_POWER,
        NOTIFICATION_CHANNEL_SAMPLE_RATE_CHANGE,
        NOTIFICATION_FREQUENCY_AND_SAMPLE_RATE_LOCKED,
        NOTIFICATION_FREQUENCY_AND_SAMPLE_RATE_UNLOCKED,
        NOTIFICATION_FREQUENCY_CHANGE,
        NOTIFICATION_FREQUENCY_CORRECTION_CHANGE,
        NOTIFICATION_FREQUENCY_ROTATION_SUCCESS,
        NOTIFICATION_FREQUENCY_ROTATION_FAILURE,
        NOTIFICATION_MEASURED_FREQUENCY_ERROR,
        NOTIFICATION_MEASURED_FREQUENCY_ERROR_SYNC_LOCKED,
        NOTIFICATION_PLL_FREQUENCY,
        NOTIFICATION_RECORDING_FILE_LOADED,
        NOTIFICATION_SAMPLE_RATE_CHANGE,
        NOTIFICATION_SQUELCH_THRESHOLD,
        NOTIFICATION_SQUELCH_AUTO_TRACK,
        NOTIFICATION_STOP_SAMPLE_STREAM,
        NOTIFICATION_TUNER_SHUTDOWN,
        NOTIFICATION_ERROR_STATE,
        REQUEST_FREQUENCY_CHANGE,
        REQUEST_FREQUENCY_ROTATION,
        REQUEST_FREQUENCY_SELECTION,
        REQUEST_CHANGE_SQUELCH_THRESHOLD,
        REQUEST_CURRENT_SQUELCH_THRESHOLD,
        REQUEST_CHANGE_SQUELCH_AUTO_TRACK,
        REQUEST_CURRENT_SQUELCH_AUTO_TRACK,
        REQUEST_START_SAMPLE_STREAM,
        REQUEST_STOP_SAMPLE_STREAM;

        public static EnumSet<Event> NOTIFICATION_EVENTS;
        public static EnumSet<Event> REQUEST_EVENTS;

        static {
            NOTIFICATION_EVENTS = EnumSet.range(NOTIFICATION_CHANNEL_COUNT_CHANGE, NOTIFICATION_STOP_SAMPLE_STREAM);
            REQUEST_EVENTS = EnumSet.range(NOTIFICATION_CHANNEL_COUNT_CHANGE, NOTIFICATION_SAMPLE_RATE_CHANGE);
        }
    }
}

