/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.settings;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import io.github.dsheirer.map.DefaultIcon;
import io.github.dsheirer.map.MapIcon;
import io.github.dsheirer.settings.ColorSetting;
import io.github.dsheirer.settings.FileSetting;
import io.github.dsheirer.settings.MapViewSetting;
import io.github.dsheirer.settings.Setting;
import io.github.dsheirer.source.recording.RecordingConfiguration;
import io.github.dsheirer.source.tuner.configuration.TunerConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@JacksonXmlRootElement(localName="SDRTrunk_settings")
public class Settings {
    private List<Setting> mSettings = new ArrayList<Setting>();
    private List<TunerConfiguration> mTunerConfiguration = new ArrayList<TunerConfiguration>();
    private List<RecordingConfiguration> mRecordingConfigurations = new ArrayList<RecordingConfiguration>();

    @JacksonXmlProperty(isAttribute=false, localName="recording_configuration")
    public List<RecordingConfiguration> getRecordingConfigurations() {
        return Collections.emptyList();
    }

    public void setRecordingConfigurations(List<RecordingConfiguration> configs) {
    }

    @JacksonXmlProperty(isAttribute=false, localName="tuner_configuration")
    public List<TunerConfiguration> getTunerConfigurations() {
        return this.mTunerConfiguration;
    }

    public void setTunerConfigurations(List<TunerConfiguration> configs) {
        this.mTunerConfiguration = configs;
    }

    @JacksonXmlProperty(isAttribute=false, localName="setting")
    public List<Setting> getSettings() {
        return this.mSettings;
    }

    public void setSettings(ArrayList<Setting> settings) {
        this.mSettings = settings;
    }

    public Setting getSetting(String name) {
        for (Setting setting : this.mSettings) {
            if (!setting.getName().contentEquals(name)) continue;
            return setting;
        }
        return null;
    }

    public void addSetting(Setting setting) {
        this.mSettings.add(setting);
    }

    public void removeSetting(Setting setting) {
        this.mSettings.remove(setting);
    }

    @JsonIgnore
    public DefaultIcon getDefaultIcon() {
        for (Setting setting : this.mSettings) {
            if (!(setting instanceof DefaultIcon)) continue;
            return (DefaultIcon)setting;
        }
        return null;
    }

    public ColorSetting getColorSetting(ColorSetting.ColorSettingName name) {
        for (Setting setting : this.mSettings) {
            if (!(setting instanceof ColorSetting) || ((ColorSetting)setting).getColorSettingName() != name) continue;
            return (ColorSetting)setting;
        }
        return null;
    }

    @JsonIgnore
    public List<ColorSetting> getColorSettings() {
        ArrayList<ColorSetting> colors = new ArrayList<ColorSetting>();
        for (Setting setting : this.mSettings) {
            if (!(setting instanceof ColorSetting)) continue;
            colors.add((ColorSetting)setting);
        }
        return colors;
    }

    public FileSetting getFileSetting(String name) {
        for (Setting setting : this.mSettings) {
            if (!(setting instanceof FileSetting) || !setting.getName().contentEquals(name)) continue;
            return (FileSetting)setting;
        }
        return null;
    }

    public MapIcon getMapIcon(String name) {
        for (Setting setting : this.mSettings) {
            if (!(setting instanceof MapIcon) || !setting.getName().contentEquals(name)) continue;
            return (MapIcon)setting;
        }
        return null;
    }

    public ArrayList<MapIcon> getMapIcons() {
        ArrayList<MapIcon> icons = new ArrayList<MapIcon>();
        for (Setting setting : this.mSettings) {
            if (!(setting instanceof MapIcon)) continue;
            icons.add((MapIcon)setting);
        }
        return icons;
    }

    public MapViewSetting getMapViewSetting(String name) {
        for (Setting setting : this.mSettings) {
            if (!(setting instanceof MapViewSetting) || !setting.getName().contentEquals(name)) continue;
            return (MapViewSetting)setting;
        }
        return null;
    }
}

