/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.settings;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.settings.Setting;
import io.github.dsheirer.settings.SettingType;
import org.jdesktop.swingx.mapviewer.GeoPosition;

@JsonSubTypes.Type(value=MapViewSetting.class, name="mapViewSetting")
public class MapViewSetting
extends Setting {
    private double mLatitude;
    private double mLongitude;
    private int mZoom;

    public MapViewSetting() {
    }

    public MapViewSetting(String name, double latitude, double longitude, int zoom) {
        super(name);
        this.mLatitude = latitude;
        this.mLongitude = longitude;
        this.mZoom = zoom;
    }

    public MapViewSetting(String name, GeoPosition position, int zoom) {
        super(name);
        this.mLatitude = position.getLatitude();
        this.mLongitude = position.getLongitude();
        this.mZoom = zoom;
    }

    @Override
    @JacksonXmlProperty(isAttribute=true, localName="type", namespace="http://www.w3.org/2001/XMLSchema-instance")
    public SettingType getType() {
        return SettingType.MAP_VIEW_SETTING;
    }

    @JacksonXmlProperty(isAttribute=true, localName="latitude")
    public double getLatitude() {
        return this.mLatitude;
    }

    public void setLatitude(double latitude) {
        this.mLatitude = latitude;
    }

    @JacksonXmlProperty(isAttribute=true, localName="longitude")
    public double getLongitude() {
        return this.mLongitude;
    }

    public void setLongitude(double longitude) {
        this.mLongitude = longitude;
    }

    @JacksonXmlProperty(isAttribute=true, localName="zoom")
    public int getZoom() {
        return this.mZoom;
    }

    public void setZoom(int zoom) {
        this.mZoom = zoom;
    }

    @JsonIgnore
    public GeoPosition getGeoPosition() {
        return new GeoPosition(this.mLatitude, this.mLongitude);
    }

    public void setGeoPosition(GeoPosition position) {
        this.mLatitude = position.getLatitude();
        this.mLongitude = position.getLongitude();
    }
}

