/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.service.radioreference;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.github.dsheirer.rrapi.RadioReferenceException;
import io.github.dsheirer.rrapi.RadioReferenceService;
import io.github.dsheirer.rrapi.type.AgencyInfo;
import io.github.dsheirer.rrapi.type.AuthorizationInformation;
import io.github.dsheirer.rrapi.type.CountyInfo;
import io.github.dsheirer.rrapi.type.Frequency;
import io.github.dsheirer.rrapi.type.Site;
import io.github.dsheirer.rrapi.type.StateInfo;
import io.github.dsheirer.rrapi.type.SystemInformation;
import io.github.dsheirer.rrapi.type.Talkgroup;
import java.util.List;

public class CachingRadioReferenceService
extends RadioReferenceService {
    private LoadingCache<Integer, AgencyInfo> mAgencyInfoCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<Integer, AgencyInfo>(){

        public AgencyInfo load(Integer key) throws Exception {
            return CachingRadioReferenceService.super.getAgencyInfo(key);
        }
    });
    private LoadingCache<Integer, CountyInfo> mCountyInfoCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<Integer, CountyInfo>(){

        public CountyInfo load(Integer key) throws Exception {
            return CachingRadioReferenceService.super.getCountyInfo(key);
        }
    });
    private LoadingCache<Integer, StateInfo> mStateInfoCache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<Integer, StateInfo>(){

        public StateInfo load(Integer key) throws Exception {
            return CachingRadioReferenceService.super.getStateInfo(key);
        }
    });
    private LoadingCache<Integer, SystemInformation> mSystemInfoCache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<Integer, SystemInformation>(){

        public SystemInformation load(Integer key) throws Exception {
            return CachingRadioReferenceService.super.getSystemInformation(key);
        }
    });
    private LoadingCache<Integer, List<Site>> mSystemSitesCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<Integer, List<Site>>(){

        public List<Site> load(Integer key) throws Exception {
            return CachingRadioReferenceService.super.getSites(key);
        }
    });
    private LoadingCache<Integer, List<Frequency>> mSubCategoryFrequencyCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<Integer, List<Frequency>>(){

        public List<Frequency> load(Integer key) throws Exception {
            return CachingRadioReferenceService.super.getSubCategoryFrequencies(key);
        }
    });
    private LoadingCache<Integer, List<Talkgroup>> mTalkgroupCache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<Integer, List<Talkgroup>>(){

        public List<Talkgroup> load(Integer key) throws Exception {
            return CachingRadioReferenceService.super.getTalkgroups(key);
        }
    });

    public CachingRadioReferenceService(AuthorizationInformation authorizationInformation) throws RadioReferenceException {
        super(authorizationInformation);
    }

    public AgencyInfo getAgencyInfo(int agencyId) throws RadioReferenceException {
        try {
            return (AgencyInfo)this.mAgencyInfoCache.get((Object)agencyId);
        }
        catch (Exception e) {
            return CachingRadioReferenceService.super.getAgencyInfo(agencyId);
        }
    }

    public CountyInfo getCountyInfo(int countyId) throws RadioReferenceException {
        try {
            return (CountyInfo)this.mCountyInfoCache.get((Object)countyId);
        }
        catch (Exception e) {
            return CachingRadioReferenceService.super.getCountyInfo(countyId);
        }
    }

    public StateInfo getStateInfo(int stateId) throws RadioReferenceException {
        try {
            return (StateInfo)this.mStateInfoCache.get((Object)stateId);
        }
        catch (Exception e) {
            return CachingRadioReferenceService.super.getStateInfo(stateId);
        }
    }

    public SystemInformation getSystemInformation(int systemId) throws RadioReferenceException {
        try {
            return (SystemInformation)this.mSystemInfoCache.get((Object)systemId);
        }
        catch (Exception e) {
            return CachingRadioReferenceService.super.getSystemInformation(systemId);
        }
    }

    public List<Site> getSites(int systemId) throws RadioReferenceException {
        try {
            return (List)this.mSystemSitesCache.get((Object)systemId);
        }
        catch (Exception e) {
            return CachingRadioReferenceService.super.getSites(systemId);
        }
    }

    public List<Frequency> getSubCategoryFrequencies(int subCategoryId) throws RadioReferenceException {
        try {
            return (List)this.mSubCategoryFrequencyCache.get((Object)subCategoryId);
        }
        catch (Exception e) {
            return CachingRadioReferenceService.super.getSubCategoryFrequencies(subCategoryId);
        }
    }

    public List<Talkgroup> getTalkgroups(int systemId) throws RadioReferenceException {
        try {
            return (List)this.mTalkgroupCache.get((Object)systemId);
        }
        catch (Exception e) {
            return CachingRadioReferenceService.super.getTalkgroups(systemId);
        }
    }
}

