/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.sample.adapter;

import io.github.dsheirer.sample.adapter.RealSampleAdapter;
import io.github.dsheirer.source.mixer.MixerChannel;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealChannelShortAdapter
extends RealSampleAdapter {
    private static final Logger mLog = LoggerFactory.getLogger(RealChannelShortAdapter.class);
    private ByteOrder mByteOrder = ByteOrder.LITTLE_ENDIAN;
    private MixerChannel mMixerChannel;
    private ByteBuffer mByteBuffer;

    public RealChannelShortAdapter(MixerChannel channel) {
        Validate.isTrue((channel != MixerChannel.MONO ? 1 : 0) != 0);
        this.mMixerChannel = channel;
    }

    @Override
    public float[] convert(byte[] samples) {
        float[] convertedSamples = new float[samples.length / 4];
        this.mByteBuffer = ByteBuffer.wrap(samples);
        this.mByteBuffer.order(this.mByteOrder);
        int pointer = 0;
        while (this.mByteBuffer.hasRemaining()) {
            if (this.mMixerChannel == MixerChannel.LEFT) {
                convertedSamples[pointer++] = (float)this.mByteBuffer.getShort() / 32768.0f;
                this.mByteBuffer.getShort();
                continue;
            }
            this.mByteBuffer.getShort();
            convertedSamples[pointer++] = (float)this.mByteBuffer.getShort() / 32768.0f;
        }
        return convertedSamples;
    }

    public void setByteOrder(ByteOrder order) {
        this.mByteOrder = order;
    }
}

