/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.sample;

import io.github.dsheirer.sample.IOverflowListener;
import io.github.dsheirer.source.Source;
import java.util.Collection;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverflowableTransferQueue<E> {
    private static final Logger mLog = LoggerFactory.getLogger(OverflowableTransferQueue.class);
    private IOverflowListener mOverflowListener;
    private Source mSourceOverflowListener;
    protected LinkedTransferQueue<E> mQueue = new LinkedTransferQueue();
    protected AtomicInteger mCounter = new AtomicInteger();
    protected AtomicBoolean mOverflow = new AtomicBoolean();
    private int mMaximumSize;
    private int mResetThreshold;

    public OverflowableTransferQueue(int maximumSize, int resetThreshold) {
        this.mMaximumSize = maximumSize;
        this.mResetThreshold = resetThreshold;
    }

    public void dispose() {
        this.clear();
        this.mOverflowListener = null;
        this.mSourceOverflowListener = null;
    }

    public void offer(E e) {
        if (!this.mOverflow.get()) {
            this.mQueue.offer(e);
            int size = this.mCounter.incrementAndGet();
            if (size > this.mMaximumSize) {
                this.setOverflow(true);
            }
        } else {
            this.overflow(e);
        }
    }

    protected void overflow(E e) {
    }

    public E poll() {
        E element = this.mQueue.poll();
        if (element != null) {
            this.mCounter.decrementAndGet();
        }
        return element;
    }

    public int drainTo(Collection<? super E> collection, int maxElements) {
        int drainCount = this.mQueue.drainTo(collection, maxElements);
        int size = this.mCounter.addAndGet(-drainCount);
        if (this.mOverflow.get() && size <= this.mResetThreshold) {
            this.setOverflow(false);
        }
        return drainCount;
    }

    public int drainTo(Collection<? super E> collection) {
        int drainCount = this.mQueue.drainTo(collection);
        int size = this.mCounter.addAndGet(-drainCount);
        if (this.mOverflow.get() && size <= this.mResetThreshold) {
            this.setOverflow(false);
        }
        return drainCount;
    }

    public void setOverflowListener(IOverflowListener listener) {
        this.mOverflowListener = listener;
    }

    public void setSourceOverflowListener(Source source) {
        this.mSourceOverflowListener = source;
    }

    private void setOverflow(boolean overflow) {
        if (this.mOverflow.compareAndSet(!overflow, overflow)) {
            if (this.mOverflowListener != null) {
                this.mOverflowListener.sourceOverflow(overflow);
            }
            if (this.mSourceOverflowListener != null) {
                this.mSourceOverflowListener.broadcastOverflowState(overflow);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedTransferQueue<E> linkedTransferQueue = this.mQueue;
        synchronized (linkedTransferQueue) {
            this.mQueue.clear();
            this.mCounter.set(0);
            this.mOverflow.set(false);
        }
    }

    public static enum State {
        NORMAL,
        OVERFLOW;

    }
}

