/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.record.wave;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.sound.sampled.AudioFormat;

public class WaveUtils {
    public static final String RIFF_ID = "RIFF";
    public static final String WAVE_ID = "WAVE";
    public static final int WAVE_HEADER_SIZE = 54;
    public static final String FORMAT_CHUNK = "fmt ";
    public static final int FORMAT_CHUNK_SIZE = 16;
    public static final short FORMAT_UNCOMPRESSED_PCM = 1;
    public static final String DATA_CHUNK = "data";
    public static final byte[] RIFF_CHUNK = new byte[]{82, 73, 70, 70};
    public static final byte[] WAV_FORMAT = new byte[]{87, 65, 86, 69};
    public static final byte[] CHUNK_FORMAT = new byte[]{102, 109, 116, 32};
    public static final byte[] CHUNK_DATA = new byte[]{100, 97, 116, 97};
    public static final int PCM_FORMAT = 1;

    public static ByteBuffer getWaveHeader(AudioFormat format) {
        ByteBuffer descriptor2 = ByteBuffer.allocate(36).order(ByteOrder.LITTLE_ENDIAN);
        descriptor2.put(RIFF_ID.getBytes());
        descriptor2.putInt(54);
        descriptor2.put(WAVE_ID.getBytes());
        descriptor2.put(FORMAT_CHUNK.getBytes());
        descriptor2.putInt(16);
        descriptor2.putShort((short)1);
        descriptor2.putShort((short)format.getChannels());
        descriptor2.putInt((int)format.getSampleRate());
        int frameByteRate2 = format.getChannels() * format.getSampleSizeInBits() / 8;
        int byteRate2 = (int)(format.getSampleRate() * (float)frameByteRate2);
        descriptor2.putInt(byteRate2);
        descriptor2.putShort((short)frameByteRate2);
        descriptor2.putShort((short)format.getSampleSizeInBits());
        ByteBuffer descriptor = ByteBuffer.allocate(44);
        descriptor.order(ByteOrder.LITTLE_ENDIAN);
        descriptor.put((byte)82);
        descriptor.put((byte)73);
        descriptor.put((byte)70);
        descriptor.put((byte)70);
        descriptor.put((byte)36);
        descriptor.put((byte)0);
        descriptor.put((byte)0);
        descriptor.put((byte)0);
        descriptor.put((byte)87);
        descriptor.put((byte)65);
        descriptor.put((byte)86);
        descriptor.put((byte)69);
        descriptor.put((byte)102);
        descriptor.put((byte)109);
        descriptor.put((byte)116);
        descriptor.put((byte)32);
        descriptor.put((byte)16);
        descriptor.put((byte)0);
        descriptor.put((byte)0);
        descriptor.put((byte)0);
        descriptor.put((byte)1);
        descriptor.put((byte)0);
        descriptor.asShortBuffer().put((short)format.getChannels());
        descriptor.position(descriptor.position() + 2);
        descriptor.asIntBuffer().put((int)format.getSampleRate());
        descriptor.position(descriptor.position() + 4);
        int frameByteRate = format.getChannels() * format.getSampleSizeInBits() / 8;
        int byteRate = (int)(format.getSampleRate() * (float)frameByteRate);
        descriptor.asIntBuffer().put(byteRate);
        descriptor.position(descriptor.position() + 4);
        descriptor.asShortBuffer().put((short)frameByteRate);
        descriptor.position(descriptor.position() + 2);
        descriptor.asShortBuffer().put((short)format.getSampleSizeInBits());
        descriptor.position(descriptor.position() + 2);
        descriptor.put((byte)100);
        descriptor.put((byte)97);
        descriptor.put((byte)116);
        descriptor.put((byte)97);
        descriptor.put((byte)0);
        descriptor.put((byte)0);
        descriptor.put((byte)0);
        descriptor.put((byte)0);
        return descriptor;
    }
}

