/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.record.wave;

import io.github.dsheirer.buffer.INativeBuffer;
import io.github.dsheirer.module.Module;
import io.github.dsheirer.record.wave.ComplexSamplesWaveRecorder;
import io.github.dsheirer.record.wave.IRecordingStatusListener;
import io.github.dsheirer.record.wave.WaveWriter;
import io.github.dsheirer.sample.ConversionUtils;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.InterleavedComplexSamples;
import io.github.dsheirer.source.ISourceEventListener;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.util.Dispatcher;
import io.github.dsheirer.util.ThreadPool;
import io.github.dsheirer.util.TimeStamp;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sound.sampled.AudioFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeBufferWaveRecorder
extends Module
implements Listener<INativeBuffer>,
ISourceEventListener {
    private static final Logger mLog = LoggerFactory.getLogger(ComplexSamplesWaveRecorder.class);
    private static final long STATUS_UPDATE_BYTE_INTERVAL = 0x100000L;
    private static final long MAX_RECORDING_SIZE = 0xFFFFFFFEL;
    private Dispatcher<INativeBuffer> mBufferProcessor = new Dispatcher("sdrtrunk native buffer wave recorder", 250L);
    private AtomicBoolean mRunning = new AtomicBoolean();
    private NativeBufferWaveWriter mWriter;
    private String mFilePrefix;
    private AudioFormat mAudioFormat;
    private IRecordingStatusListener mStatusListener;
    private String mFilePath;
    private long mCurrentSize = 0L;
    private long mLastReportedSize = 0L;
    private int mRecordingCount = 0;

    public NativeBufferWaveRecorder(float sampleRate, String filePrefix, IRecordingStatusListener statusListener) {
        this.mFilePrefix = filePrefix;
        this.mStatusListener = statusListener;
        this.setSampleRate(sampleRate);
    }

    public void setSampleRate(float sampleRate) {
        if (this.mAudioFormat == null || this.mAudioFormat.getSampleRate() != sampleRate) {
            this.mAudioFormat = new AudioFormat(sampleRate, 16, 2, true, false);
            if (this.mRunning.get()) {
                this.stop();
                this.start();
            }
        }
    }

    private String getFileName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mFilePrefix);
        sb.append("_");
        sb.append(TimeStamp.getTimeStamp("_"));
        sb.append(".wav");
        return sb.toString();
    }

    @Override
    public void start() {
        if (this.mRunning.compareAndSet(false, true)) {
            this.mRecordingCount = 1;
            this.mCurrentSize = 0L;
            this.mLastReportedSize = 0L;
            try {
                this.mFilePath = this.getFileName();
                this.mWriter = new NativeBufferWaveWriter(this.mAudioFormat, Paths.get(this.mFilePath, new String[0]));
                this.mBufferProcessor.setListener(this.mWriter);
                this.mStatusListener.update(this.mRecordingCount, this.mFilePath, 0L);
                this.mBufferProcessor.start();
            }
            catch (IOException io) {
                mLog.error("Error starting complex baseband recorder", (Throwable)io);
            }
        }
    }

    private void rollRecording() {
        if (this.mWriter != null) {
            try {
                this.mWriter.close();
                this.mWriter = null;
            }
            catch (IOException ioe) {
                mLog.error("Error closing recording during file rollover");
            }
            this.mCurrentSize = 0L;
            this.mLastReportedSize = 0L;
            try {
                this.mFilePath = this.getFileName();
                this.mWriter = new NativeBufferWaveWriter(this.mAudioFormat, Paths.get(this.mFilePath, new String[0]));
                this.mBufferProcessor.setListener(this.mWriter);
                this.mStatusListener.update(++this.mRecordingCount, this.mFilePath, 0L);
            }
            catch (IOException ioe) {
                mLog.error("Error creating new recording during file rollover");
                this.stop();
            }
        }
    }

    @Override
    public void stop() {
        if (this.mRunning.compareAndSet(true, false)) {
            if (this.mBufferProcessor != null) {
                this.mBufferProcessor.stop();
                this.mBufferProcessor.setListener(null);
            }
            if (this.mWriter != null) {
                ThreadPool.CACHED.submit(() -> {
                    try {
                        this.mWriter.close();
                    }
                    catch (IOException ioe) {
                        mLog.error("Error closing baseband I/Q recorder", (Throwable)ioe);
                    }
                });
            }
        }
    }

    @Override
    public void receive(INativeBuffer nativeBuffer) {
        if (this.mRunning.get()) {
            this.mBufferProcessor.receive(nativeBuffer);
        }
    }

    public Listener<INativeBuffer> getReusableComplexBufferListener() {
        return this;
    }

    @Override
    public void reset() {
    }

    @Override
    public Listener<SourceEvent> getSourceEventListener() {
        return sourceEvent -> {
            switch (sourceEvent.getEvent()) {
                case NOTIFICATION_SAMPLE_RATE_CHANGE: {
                    this.setSampleRate(sourceEvent.getValue().floatValue());
                }
            }
        };
    }

    public class NativeBufferWaveWriter
    extends WaveWriter
    implements Listener<INativeBuffer> {
        public NativeBufferWaveWriter(AudioFormat format, Path file) throws IOException {
            super(format, file);
        }

        @Override
        public void receive(INativeBuffer nativeBuffer) {
            boolean error = false;
            Iterator<InterleavedComplexSamples> iterator = nativeBuffer.iteratorInterleaved();
            while (iterator.hasNext() & !error) {
                try {
                    ByteBuffer data = ConversionUtils.convertToSigned16BitSamples(iterator.next());
                    if (NativeBufferWaveRecorder.this.mCurrentSize + (long)data.array().length > 0xFFFFFFFEL) {
                        NativeBufferWaveRecorder.this.rollRecording();
                    }
                    NativeBufferWaveRecorder.this.mWriter.writeData(data);
                    NativeBufferWaveRecorder.this.mCurrentSize += (long)data.array().length;
                    if (NativeBufferWaveRecorder.this.mCurrentSize <= NativeBufferWaveRecorder.this.mLastReportedSize + 0x100000L) continue;
                    NativeBufferWaveRecorder.this.mStatusListener.update(NativeBufferWaveRecorder.this.mRecordingCount, NativeBufferWaveRecorder.this.mFilePath, NativeBufferWaveRecorder.this.mCurrentSize);
                    NativeBufferWaveRecorder.this.mLastReportedSize = NativeBufferWaveRecorder.this.mCurrentSize;
                }
                catch (IOException ioe) {
                    mLog.error("I/O exception while writing I/Q buffers to wave recorder - stopping recorder", (Throwable)ioe);
                    error = true;
                    NativeBufferWaveRecorder.this.stop();
                }
            }
        }
    }
}

