/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.record.wave;

import com.google.common.base.Joiner;
import com.mpatric.mp3agic.ID3v24Tag;
import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.AliasList;
import io.github.dsheirer.identifier.Form;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.configuration.ChannelNameConfigurationIdentifier;
import io.github.dsheirer.identifier.configuration.DecoderTypeConfigurationIdentifier;
import io.github.dsheirer.identifier.configuration.FrequencyConfigurationIdentifier;
import io.github.dsheirer.identifier.configuration.SiteConfigurationIdentifier;
import io.github.dsheirer.identifier.configuration.SystemConfigurationIdentifier;
import io.github.dsheirer.identifier.decoder.DecoderLogicalChannelNameIdentifier;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.properties.SystemProperties;
import io.github.dsheirer.record.wave.AudioMetadata;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioMetadataUtils {
    private static final Logger mLog = LoggerFactory.getLogger(AudioMetadataUtils.class);
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final SimpleDateFormat YEAR_SDF = new SimpleDateFormat("yyyy");
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final byte NULL_TERMINATOR = 0;
    private static final String LIST_CHUNK_IDENTIFIER = "LIST";
    private static final String ID3_CHUNK_IDENTIFIER = "id3 ";
    private static final String INFO_TYPE_IDENTIFIER = "INFO";
    private static final String GENRE_SCANNER_AUDIO = "Scanner Audio";
    private static final String COMMENT_SEPARATOR = ";";

    private AudioMetadataUtils() {
    }

    public static Map<AudioMetadata, String> getMetadataMap(IdentifierCollection identifierCollection, AliasList aliasList) {
        EnumMap<AudioMetadata, String> audioMetadata = new EnumMap<AudioMetadata, String>(AudioMetadata.class);
        StringBuilder comments = new StringBuilder();
        audioMetadata.put(AudioMetadata.COMPOSER, SystemProperties.getInstance().getApplicationName());
        String dateCreated = SDF.format(new Date(System.currentTimeMillis()));
        audioMetadata.put(AudioMetadata.DATE_CREATED, dateCreated);
        comments.append("Date:").append(dateCreated).append(COMMENT_SEPARATOR);
        audioMetadata.put(AudioMetadata.YEAR, YEAR_SDF.format(new Date(System.currentTimeMillis())));
        audioMetadata.put(AudioMetadata.GENRE, GENRE_SCANNER_AUDIO);
        if (identifierCollection != null) {
            Identifier frequency;
            Identifier channelName;
            Identifier decoder;
            Identifier channel;
            Identifier site;
            Identifier from;
            StringBuilder sb;
            Identifier to = identifierCollection.getToIdentifier();
            if (to != null) {
                sb = new StringBuilder();
                sb.append(to.toString());
                List<Alias> toAliases = aliasList.getAliases(to);
                if (!toAliases.isEmpty()) {
                    sb.append("\"").append(Joiner.on((String)"\",\"").join(toAliases)).append("\"");
                }
                audioMetadata.put(AudioMetadata.TRACK_TITLE, sb.toString());
            }
            if ((from = identifierCollection.getFromIdentifier()) != null) {
                sb = new StringBuilder();
                sb.append(from.toString());
                List<Alias> fromAliases = aliasList.getAliases(from);
                for (Alias alias : fromAliases) {
                    sb.append(" ").append(alias.toString());
                }
                audioMetadata.put(AudioMetadata.ARTIST_NAME, sb.toString());
            }
            sb = null;
            Identifier system = identifierCollection.getIdentifier(IdentifierClass.CONFIGURATION, Form.SYSTEM, Role.ANY);
            if (system instanceof SystemConfigurationIdentifier) {
                String value = (String)((SystemConfigurationIdentifier)system).getValue();
                audioMetadata.put(AudioMetadata.GROUPING, value);
                comments.append("System:").append(value).append(COMMENT_SEPARATOR);
            }
            if ((site = identifierCollection.getIdentifier(IdentifierClass.CONFIGURATION, Form.SITE, Role.ANY)) instanceof SiteConfigurationIdentifier) {
                comments.append("Site:").append((String)((SiteConfigurationIdentifier)site).getValue()).append(COMMENT_SEPARATOR);
            }
            if ((channel = identifierCollection.getIdentifier(IdentifierClass.CONFIGURATION, Form.CHANNEL, Role.ANY)) instanceof ChannelNameConfigurationIdentifier) {
                String value = (String)((ChannelNameConfigurationIdentifier)channel).getValue();
                audioMetadata.put(AudioMetadata.ALBUM_TITLE, value);
                comments.append("Name:").append(value).append(COMMENT_SEPARATOR);
            }
            if ((decoder = identifierCollection.getIdentifier(IdentifierClass.CONFIGURATION, Form.DECODER_TYPE, Role.ANY)) instanceof DecoderTypeConfigurationIdentifier) {
                comments.append("Decoder:").append(((DecoderType)((Object)((DecoderTypeConfigurationIdentifier)decoder).getValue())).getDisplayString()).append(COMMENT_SEPARATOR);
            }
            if ((channelName = identifierCollection.getIdentifier(IdentifierClass.DECODER, Form.CHANNEL_NAME, Role.BROADCAST)) instanceof DecoderLogicalChannelNameIdentifier) {
                comments.append("Channel:").append((String)((DecoderLogicalChannelNameIdentifier)channelName).getValue()).append(COMMENT_SEPARATOR);
            }
            if ((frequency = identifierCollection.getIdentifier(IdentifierClass.CONFIGURATION, Form.CHANNEL_FREQUENCY, Role.ANY)) instanceof FrequencyConfigurationIdentifier) {
                comments.append("Frequency:").append(((FrequencyConfigurationIdentifier)frequency).getValue()).append(COMMENT_SEPARATOR);
            }
        }
        audioMetadata.put(AudioMetadata.COMMENTS, comments.toString());
        return audioMetadata;
    }

    public static byte[] getMP3ID3(Map<AudioMetadata, String> metadataMap) {
        ID3v24Tag tag = new ID3v24Tag();
        for (Map.Entry<AudioMetadata, String> entry : metadataMap.entrySet()) {
            switch (entry.getKey()) {
                case ALBUM_TITLE: {
                    tag.setAlbum(entry.getValue());
                    break;
                }
                case ARTIST_NAME: {
                    tag.setArtist(entry.getValue());
                    break;
                }
                case COMMENTS: {
                    tag.setComment(entry.getValue());
                    break;
                }
                case COMPOSER: {
                    tag.setComposer(entry.getValue());
                    break;
                }
                case DATE_CREATED: {
                    tag.setDate(entry.getValue());
                    break;
                }
                case GENRE: {
                    tag.setGenreDescription(entry.getValue());
                    break;
                }
                case GROUPING: {
                    tag.setGrouping(entry.getValue());
                    break;
                }
                case TRACK_TITLE: {
                    tag.setTitle(entry.getValue());
                    break;
                }
                case YEAR: {
                    tag.setYear(entry.getValue());
                }
            }
        }
        try {
            return tag.toBytes();
        }
        catch (Exception e) {
            mLog.error("Error creating MP3 ID3 tag bytes", (Throwable)e);
            return new byte[0];
        }
    }

    public static ByteBuffer getID3Chunk(byte[] contents) {
        int length = contents.length;
        if (length % 4 != 0) {
            length += 4 - length % 4;
        }
        ByteBuffer chunk = ByteBuffer.allocate(length + 8).order(ByteOrder.LITTLE_ENDIAN);
        chunk.put(ID3_CHUNK_IDENTIFIER.getBytes());
        chunk.putInt(length);
        chunk.put(contents);
        return chunk;
    }

    public static ByteBuffer getLISTChunk(Map<AudioMetadata, String> metadataMap) {
        ByteBuffer metadataBuffer = AudioMetadataUtils.getLISTSubChunks(metadataMap);
        int tagsLength = metadataBuffer.capacity();
        int overallLength = tagsLength + 8;
        int padding = 0;
        if (overallLength % 4 != 0) {
            padding = 4 - overallLength % 4;
        }
        ByteBuffer chunk = ByteBuffer.allocate(overallLength + padding).order(ByteOrder.LITTLE_ENDIAN);
        chunk.put(LIST_CHUNK_IDENTIFIER.getBytes());
        chunk.putInt(tagsLength + padding);
        chunk.put(metadataBuffer);
        chunk.position(0);
        return chunk;
    }

    private static ByteBuffer getLISTSubChunks(Map<AudioMetadata, String> metadataMap) {
        ByteBuffer buffer2;
        int length = INFO_TYPE_IDENTIFIER.length();
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        for (Map.Entry<AudioMetadata, String> entry : metadataMap.entrySet()) {
            if (!entry.getKey().isPrimaryTag()) continue;
            buffer2 = AudioMetadataUtils.getLISTSubChunk(entry.getKey(), entry.getValue());
            length += buffer2.capacity();
            buffers.add(buffer2);
        }
        for (Map.Entry<AudioMetadata, String> entry : metadataMap.entrySet()) {
            if (entry.getKey().isPrimaryTag()) continue;
            buffer2 = AudioMetadataUtils.getLISTSubChunk(entry.getKey(), entry.getValue());
            length += buffer2.capacity();
            buffers.add(buffer2);
        }
        ByteBuffer joinedBuffer = ByteBuffer.allocate(length);
        joinedBuffer.put(INFO_TYPE_IDENTIFIER.getBytes());
        for (ByteBuffer buffer2 : buffers) {
            joinedBuffer.put(buffer2);
        }
        joinedBuffer.position(0);
        return joinedBuffer;
    }

    private static ByteBuffer getLISTSubChunk(AudioMetadata type, String value) {
        if (value != null && !value.isEmpty()) {
            ByteBuffer encodedValue = UTF_8.encode(value);
            int chunkLength = encodedValue.capacity() + 9;
            ByteBuffer buffer = ByteBuffer.allocate(chunkLength).order(ByteOrder.LITTLE_ENDIAN);
            buffer.put(type.getLISTTag().getBytes());
            buffer.putInt(encodedValue.capacity() + 1);
            buffer.put(encodedValue);
            buffer.put((byte)0);
            buffer.position(0);
            return buffer;
        }
        return null;
    }
}

