/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.record.binary;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryReader
implements Iterator<ByteBuffer>,
AutoCloseable {
    private static final Logger mLog = LoggerFactory.getLogger(BinaryReader.class);
    private int mBufferSize;
    private InputStream mInputStream;
    private Path mPath;
    private ByteBuffer mNextBuffer;

    public BinaryReader(Path path, int bufferSize) throws IOException {
        this.mBufferSize = bufferSize;
        this.mPath = path;
        this.mInputStream = new BufferedInputStream(new FileInputStream(path.toFile()));
        this.getNext();
    }

    @Override
    public void close() throws Exception {
        if (this.mInputStream != null) {
            this.mInputStream.close();
            this.mInputStream = null;
            this.mPath = null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.mNextBuffer != null;
    }

    @Override
    public ByteBuffer next() {
        ByteBuffer current = this.mNextBuffer;
        this.getNext();
        return current;
    }

    private void getNext() {
        try {
            byte[] readBytes = new byte[this.mBufferSize];
            int bytesRead = this.mInputStream.read(readBytes);
            if (bytesRead < readBytes.length && bytesRead > 0) {
                readBytes = Arrays.copyOf(readBytes, bytesRead);
            }
            this.mNextBuffer = bytesRead > 0 ? ByteBuffer.wrap(readBytes) : null;
        }
        catch (IOException e) {
            mLog.error("Error reading binary file [" + this.mPath.toString() + "]", (Throwable)e);
            this.mNextBuffer = null;
        }
    }
}

