/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.record;

import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.module.Module;
import io.github.dsheirer.module.decode.dmr.audio.DMRCallSequenceRecorder;
import io.github.dsheirer.module.decode.p25.audio.P25P1CallSequenceRecorder;
import io.github.dsheirer.module.decode.p25.audio.P25P2CallSequenceRecorder;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.record.RecorderType;
import io.github.dsheirer.record.binary.BinaryRecorder;
import io.github.dsheirer.record.wave.ComplexSamplesWaveRecorder;
import io.github.dsheirer.record.wave.IRecordingStatusListener;
import io.github.dsheirer.record.wave.NativeBufferWaveRecorder;
import io.github.dsheirer.source.config.SourceConfigTuner;
import io.github.dsheirer.source.config.SourceConfigTunerMultipleFrequency;
import io.github.dsheirer.util.StringUtils;
import io.github.dsheirer.util.TimeStamp;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class RecorderFactory {
    public static final float BASEBAND_SAMPLE_RATE = 25000.0f;

    public static List<Module> getRecorders(UserPreferences userPreferences, Channel channel) {
        ArrayList<Module> recorderModules = new ArrayList<Module>();
        for (RecorderType recorderType : channel.getRecordConfiguration().getRecorders()) {
            long frequency = RecorderFactory.getFrequency(channel);
            block0 : switch (recorderType) {
                case BASEBAND: {
                    if (!channel.isStandardChannel()) break;
                    recorderModules.add(RecorderFactory.getBasebandRecorder(channel.toString(), frequency, userPreferences));
                    break;
                }
                case DEMODULATED_BIT_STREAM: {
                    if (!channel.isStandardChannel() || !channel.getDecodeConfiguration().getDecoderType().providesBitstream()) break;
                    recorderModules.add(new BinaryRecorder(RecorderFactory.getRecordingBasePath(userPreferences), StringUtils.replaceIllegalCharacters(channel.toString()), channel.getDecodeConfiguration().getDecoderType().getProtocol(), frequency));
                    break;
                }
                case TRAFFIC_BASEBAND: {
                    if (!channel.isTrafficChannel()) break;
                    recorderModules.add(RecorderFactory.getBasebandRecorder(channel.toString(), frequency, userPreferences));
                    break;
                }
                case TRAFFIC_DEMODULATED_BIT_STREAM: {
                    if (!channel.isTrafficChannel() || !channel.getDecodeConfiguration().getDecoderType().providesBitstream()) break;
                    recorderModules.add(new BinaryRecorder(RecorderFactory.getRecordingBasePath(userPreferences), StringUtils.replaceIllegalCharacters(channel.toString()), channel.getDecodeConfiguration().getDecoderType().getProtocol(), frequency));
                    break;
                }
                case MBE_CALL_SEQUENCE: {
                    if (!channel.isStandardChannel() || !(channel.getSourceConfiguration() instanceof SourceConfigTuner)) break;
                    switch (channel.getDecodeConfiguration().getDecoderType()) {
                        case DMR: {
                            recorderModules.add(new DMRCallSequenceRecorder(userPreferences, frequency, channel.getSystem(), channel.getSite()));
                            break block0;
                        }
                        case P25_PHASE1: {
                            recorderModules.add(new P25P1CallSequenceRecorder(userPreferences, frequency, channel.getSystem(), channel.getSite()));
                            break block0;
                        }
                        case P25_PHASE2: {
                            recorderModules.add(new P25P2CallSequenceRecorder(userPreferences, frequency, channel.getSystem(), channel.getSite()));
                        }
                    }
                    break;
                }
                case TRAFFIC_MBE_CALL_SEQUENCE: {
                    if (!channel.isTrafficChannel() || !(channel.getSourceConfiguration() instanceof SourceConfigTuner)) break;
                    switch (channel.getDecodeConfiguration().getDecoderType()) {
                        case DMR: {
                            recorderModules.add(new DMRCallSequenceRecorder(userPreferences, frequency, channel.getSystem(), channel.getSite()));
                            break block0;
                        }
                        case P25_PHASE1: {
                            recorderModules.add(new P25P1CallSequenceRecorder(userPreferences, frequency, channel.getSystem(), channel.getSite()));
                            break block0;
                        }
                        case P25_PHASE2: {
                            recorderModules.add(new P25P2CallSequenceRecorder(userPreferences, frequency, channel.getSystem(), channel.getSite()));
                        }
                    }
                }
            }
        }
        return recorderModules;
    }

    private static long getFrequency(Channel channel) {
        if (channel.getSourceConfiguration() instanceof SourceConfigTuner) {
            return ((SourceConfigTuner)channel.getSourceConfiguration()).getFrequency();
        }
        if (channel.getSourceConfiguration() instanceof SourceConfigTunerMultipleFrequency) {
            return ((SourceConfigTunerMultipleFrequency)channel.getSourceConfiguration()).getFrequencies().get(0);
        }
        return 0L;
    }

    public static Path getRecordingBasePath(UserPreferences userPreferences) {
        return userPreferences.getDirectoryPreference().getDirectoryRecording();
    }

    public static ComplexSamplesWaveRecorder getBasebandRecorder(String channelName, long frequency, UserPreferences userPreferences) {
        StringBuilder sb = new StringBuilder();
        sb.append(RecorderFactory.getRecordingBasePath(userPreferences));
        sb.append(File.separator);
        sb.append(TimeStamp.getTimeStamp("_"));
        sb.append("_");
        sb.append(frequency);
        sb.append("_");
        sb.append(StringUtils.replaceIllegalCharacters(channelName)).append("_baseband");
        return new ComplexSamplesWaveRecorder(25000.0f, sb.toString());
    }

    public static NativeBufferWaveRecorder getTunerRecorder(String channelName, UserPreferences userPreferences, IRecordingStatusListener statusListener) {
        StringBuilder sb = new StringBuilder();
        sb.append(RecorderFactory.getRecordingBasePath(userPreferences));
        sb.append(File.separator).append(StringUtils.replaceIllegalCharacters(channelName)).append("_baseband");
        return new NativeBufferWaveRecorder(25000.0f, sb.toString(), statusListener);
    }
}

