/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.preference.swing;

import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwingPreference {
    private static final Logger mLog = LoggerFactory.getLogger(SwingPreference.class);
    private static final String LOCATION_X = ".x";
    private static final String LOCATION_Y = ".y";
    private static final String SIZE_HEIGHT = ".height";
    private static final String SIZE_WIDTH = ".width";
    private static final String MAXIMIZED = ".maximized";
    private Preferences mPreferences = Preferences.userNodeForPackage(SwingPreference.class);

    public int getInt(String key, int defaultValue) {
        return this.mPreferences.getInt(key, defaultValue);
    }

    public void setInt(String key, int value) {
        this.mPreferences.putInt(key, value);
    }

    public Point getLocation(String key) {
        int x = this.mPreferences.getInt(key + LOCATION_X, Integer.MAX_VALUE);
        int y = this.mPreferences.getInt(key + LOCATION_Y, Integer.MAX_VALUE);
        if (x != Integer.MAX_VALUE && y != Integer.MAX_VALUE) {
            Point location = new Point(x, y);
            return location;
        }
        return null;
    }

    public void setLocation(String key, Point location) {
        this.mPreferences.putInt(key + LOCATION_X, location.x);
        this.mPreferences.putInt(key + LOCATION_Y, location.y);
    }

    public void setMaximized(String key, boolean maximized) {
        this.mPreferences.putBoolean(key + MAXIMIZED, maximized);
    }

    public boolean getMaximized(String key, boolean defaultMaximized) {
        return this.mPreferences.getBoolean(key + MAXIMIZED, defaultMaximized);
    }

    public Dimension getDimension(String key) {
        int height = this.mPreferences.getInt(key + SIZE_HEIGHT, Integer.MAX_VALUE);
        int width = this.mPreferences.getInt(key + SIZE_WIDTH, Integer.MAX_VALUE);
        if (height != Integer.MAX_VALUE && width != Integer.MAX_VALUE) {
            return new Dimension(width, height);
        }
        return null;
    }

    public void setDimension(String key, Dimension dimension) {
        this.mPreferences.putInt(key + SIZE_HEIGHT, dimension.height);
        this.mPreferences.putInt(key + SIZE_WIDTH, dimension.width);
    }

    private boolean isValidWindowLocation(Point location) {
        for (GraphicsDevice gd : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            if (!gd.getDefaultConfiguration().getBounds().contains(location)) continue;
            return true;
        }
        return false;
    }
}

