/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.preference.swing;

import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.util.ThreadPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumnModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JTableColumnWidthMonitor {
    private static final Logger mLog = LoggerFactory.getLogger(JTableColumnWidthMonitor.class);
    private UserPreferences mUserPreferences;
    private JTable mTable;
    private String mKey;
    private ColumnResizeListener mColumnResizeListener = new ColumnResizeListener();
    private AtomicBoolean mSaveInProgress = new AtomicBoolean();

    public JTableColumnWidthMonitor(UserPreferences userPreferences, JTable table, String key) {
        this.mUserPreferences = userPreferences;
        this.mTable = table;
        this.mKey = key;
        this.restoreColumnWidths();
        this.mTable.getColumnModel().addColumnModelListener(this.mColumnResizeListener);
    }

    public void dispose() {
        if (this.mTable != null && this.mColumnResizeListener != null) {
            this.mTable.getColumnModel().removeColumnModelListener(this.mColumnResizeListener);
        }
        this.mTable = null;
        this.mUserPreferences = null;
    }

    private void restoreColumnWidths() {
        TableColumnModel model = this.mTable.getColumnModel();
        for (int x = 0; x < model.getColumnCount(); ++x) {
            int width = this.mUserPreferences.getSwingPreference().getInt(this.getColumnKey(x), Integer.MAX_VALUE);
            if (width == Integer.MAX_VALUE) continue;
            model.getColumn(x).setPreferredWidth(width);
        }
    }

    private void storeColumnWidths() {
        TableColumnModel model = this.mTable.getColumnModel();
        for (int x = 0; x < model.getColumnCount(); ++x) {
            this.mUserPreferences.getSwingPreference().setInt(this.getColumnKey(x), model.getColumn(x).getWidth());
        }
    }

    private String getColumnKey(int column) {
        return this.mKey + ".column." + column;
    }

    class ColumnResizeListener
    implements TableColumnModelListener {
        ColumnResizeListener() {
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
            if (JTableColumnWidthMonitor.this.mSaveInProgress.compareAndSet(false, true)) {
                ThreadPool.SCHEDULED.schedule(new ColumnWidthSaveTask(), 2L, TimeUnit.SECONDS);
            }
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }

    public class ColumnWidthSaveTask
    implements Runnable {
        @Override
        public void run() {
            JTableColumnWidthMonitor.this.storeColumnWidths();
            JTableColumnWidthMonitor.this.mSaveInProgress.set(false);
        }
    }
}

