/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.preference.source;

import io.github.dsheirer.gui.preference.tuner.RspDuoSelectionMode;
import io.github.dsheirer.preference.Preference;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.preference.source.ChannelizerType;
import io.github.dsheirer.sample.Listener;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunerPreference
extends Preference {
    private static final Logger mLog = LoggerFactory.getLogger(TunerPreference.class);
    private Preferences mPreferences = Preferences.userNodeForPackage(TunerPreference.class);
    private static final String PREFERENCE_KEY_CHANNELIZER_TYPE = "channelizer.type";
    private static final String PREFERENCE_KEY_RSP_DUO_TUNER_MODE = "rsp.duo.tuner.mode";
    private ChannelizerType mChannelizerType;
    private RspDuoSelectionMode mRspDuoSelectionMode;

    public TunerPreference(Listener<PreferenceType> updateListener) {
        super(updateListener);
    }

    @Override
    public PreferenceType getPreferenceType() {
        return PreferenceType.TUNER;
    }

    public ChannelizerType getChannelizerType() {
        if (this.mChannelizerType == null) {
            String type = this.mPreferences.get(PREFERENCE_KEY_CHANNELIZER_TYPE, ChannelizerType.POLYPHASE.name());
            if (type != null) {
                if (type.equalsIgnoreCase(ChannelizerType.POLYPHASE.name())) {
                    this.mChannelizerType = ChannelizerType.POLYPHASE;
                } else if (type.equalsIgnoreCase(ChannelizerType.HETERODYNE.name())) {
                    this.mChannelizerType = ChannelizerType.HETERODYNE;
                }
            }
            if (type == null) {
                this.mChannelizerType = ChannelizerType.POLYPHASE;
            }
        }
        return this.mChannelizerType;
    }

    public void setChannelizerType(ChannelizerType type) {
        this.mChannelizerType = type;
        this.mPreferences.put(PREFERENCE_KEY_CHANNELIZER_TYPE, this.mChannelizerType.name());
        this.notifyPreferenceUpdated();
    }

    public RspDuoSelectionMode getRspDuoTunerMode() {
        if (this.mRspDuoSelectionMode == null) {
            String mode = this.mPreferences.get(PREFERENCE_KEY_RSP_DUO_TUNER_MODE, RspDuoSelectionMode.DUAL.name());
            this.mRspDuoSelectionMode = RspDuoSelectionMode.fromValue(mode);
        }
        return this.mRspDuoSelectionMode;
    }

    public void setRspDuoTunerMode(RspDuoSelectionMode mode) {
        this.mRspDuoSelectionMode = mode;
        this.mPreferences.put(PREFERENCE_KEY_RSP_DUO_TUNER_MODE, this.mRspDuoSelectionMode.name());
        this.notifyPreferenceUpdated();
    }
}

