/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.preference.source;

import io.github.dsheirer.preference.Preference;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.sample.Listener;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelMultiFrequencyPreference
extends Preference {
    private static final Logger mLog = LoggerFactory.getLogger(ChannelMultiFrequencyPreference.class);
    private Preferences mPreferences = Preferences.userNodeForPackage(ChannelMultiFrequencyPreference.class);
    private static final String PREFERENCE_KEY_ROTATION_DELAY = "rotation.delay";
    private static final long DEFAULT_ROTATION_DELAY = 5000L;
    private Long mRotationDelay;

    public ChannelMultiFrequencyPreference(Listener<PreferenceType> updateListener) {
        super(updateListener);
    }

    @Override
    public PreferenceType getPreferenceType() {
        return PreferenceType.MULTI_FREQUENCY;
    }

    public long getRotationDelay() {
        if (this.mRotationDelay == null) {
            this.mRotationDelay = this.mPreferences.getLong(PREFERENCE_KEY_ROTATION_DELAY, 5000L);
        }
        return this.mRotationDelay;
    }

    public void setRotationDelay(long rotationDelay) {
        if (1000L <= rotationDelay && rotationDelay <= 60000L) {
            this.mRotationDelay = rotationDelay;
            this.mPreferences.putLong(PREFERENCE_KEY_ROTATION_DELAY, this.mRotationDelay);
            this.notifyPreferenceUpdated();
        }
    }

    public void resetRotationDelay() {
        this.mPreferences.remove(PREFERENCE_KEY_ROTATION_DELAY);
        this.mRotationDelay = null;
        this.notifyPreferenceUpdated();
    }
}

