/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.preference.record;

import io.github.dsheirer.preference.Preference;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.record.RecordFormat;
import io.github.dsheirer.sample.Listener;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordPreference
extends Preference {
    private static final String PREFERENCE_KEY_AUDIO_RECORD_FORMAT = "audio.record.format";
    private static final RecordFormat DEFAULT_RECORD_FORMAT = RecordFormat.MP3;
    private static final Logger mLog = LoggerFactory.getLogger(RecordPreference.class);
    private Preferences mPreferences = Preferences.userNodeForPackage(RecordPreference.class);
    private RecordFormat mAudioRecordFormat;

    public RecordPreference(Listener<PreferenceType> updateListener) {
        super(updateListener);
    }

    @Override
    public PreferenceType getPreferenceType() {
        return PreferenceType.RECORD;
    }

    public RecordFormat getAudioRecordFormat() {
        if (this.mAudioRecordFormat == null) {
            try {
                String format = this.mPreferences.get(PREFERENCE_KEY_AUDIO_RECORD_FORMAT, DEFAULT_RECORD_FORMAT.name());
                this.mAudioRecordFormat = RecordFormat.valueOf(format);
            }
            catch (Exception e) {
                mLog.error("Error parsing record format preference", (Throwable)e);
            }
            if (this.mAudioRecordFormat == null) {
                this.mAudioRecordFormat = DEFAULT_RECORD_FORMAT;
            }
        }
        return this.mAudioRecordFormat;
    }

    public void setAudioRecordFormat(RecordFormat audioRecordFormat) {
        this.mAudioRecordFormat = audioRecordFormat;
        this.mPreferences.put(PREFERENCE_KEY_AUDIO_RECORD_FORMAT, audioRecordFormat.name());
        this.notifyPreferenceUpdated();
    }
}

