/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.preference.radioreference;

import io.github.dsheirer.gui.playlist.radioreference.Level;
import io.github.dsheirer.preference.Preference;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.rrapi.type.AuthorizationInformation;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.service.radioreference.RadioReference;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadioReferencePreference
extends Preference {
    private static final Logger mLog = LoggerFactory.getLogger(RadioReferencePreference.class);
    public static final int INVALID_ID = -1;
    private Preferences mPreferences = Preferences.userNodeForPackage(RadioReferencePreference.class);
    private static final String STORE_CREDENTIALS = "store.credentials";
    private static final String USER_NAME = "user.name";
    private static final String PASSWORD = "user.authorization";
    private static final String SHOW_PASSWORD = "show.password";
    private static final String PREFERRED_COUNTRY_ID = "preferred.country";
    private static final String PREFERRED_STATE_ID = "preferred.state";
    private static final String PREFERRED_COUNTY_ID = "preferred.county";
    private static final String PREFERRED_SYSTEM_ID_STATE = "preferred.system.state";
    private static final String PREFERRED_SYSTEM_ID_COUNTY = "preferred.system.county";
    private static final String PREFERRED_AGENCY_ID_NATIONAL = "preferred.agency.national";
    private static final String PREFERRED_AGENCY_ID_STATE = "preferred.agency.state";
    private static final String PREFERRED_AGENCY_ID_COUNTY = "preferred.agency.county";
    private static final String SHOW_CHANNEL_EDITOR_NATIONAL = "create.and.show.editor.national";
    private static final String SHOW_CHANNEL_EDITOR_STATE = "create.and.show.editor.state";
    private static final String SHOW_CHANNEL_EDITOR_COUNTY = "create.and.show.editor.county";
    private static final String ENCRYPTED_TALKGROUP_DO_NOT_MONITOR = "encrypted.talkgroup.import.do.not.monitor";
    private static final String CREATE_AND_SHOW_CHANNEL_EDITOR = "create.and.show.channel.editor";
    private String mUserName;
    private String mPassword;
    private Boolean mStoreCredentials;
    private Boolean mShowPassword;
    private Boolean mShowChannelEditorNational;
    private Boolean mShowChannelEditorState;
    private Boolean mShowChannelEditorCounty;
    private Boolean mEncryptedTalkgroupImport;
    private Boolean mCreateAndShowChannelEditor;
    private int mPreferredCountryId = -1;
    private int mPreferredStateId = -1;
    private int mPreferredCountyId = -1;
    private int mPreferredAgencyIdNational = -1;
    private int mPreferredAgencyIdState = -1;
    private int mPreferredAgencyIdCounty = -1;
    private int mPreferredSystemIdState = -1;
    private int mPreferredSystemIdCounty = -1;

    public RadioReferencePreference(Listener<PreferenceType> updateListener) {
        super(updateListener);
        this.loadSettings();
    }

    @Override
    public PreferenceType getPreferenceType() {
        return PreferenceType.RADIO_REFERENCE;
    }

    private void loadSettings() {
        this.mStoreCredentials = this.mPreferences.getBoolean(STORE_CREDENTIALS, true);
    }

    public void removeStoredCredentials() {
        this.setStoreCredentials(false);
        this.setUserName(null);
        this.setPassword(null);
        this.notifyPreferenceUpdated();
    }

    public boolean hasStoredCredentials() {
        return this.mPreferences.get(USER_NAME, null) != null || this.mPreferences.get(PASSWORD, null) != null;
    }

    public AuthorizationInformation getAuthorizationInformation() {
        if (this.hasStoredCredentials()) {
            String username = this.getUserName();
            String password = this.getPassword();
            return RadioReference.getAuthorizatonInformation(username, password);
        }
        return null;
    }

    public String getUserName() {
        if (this.mUserName == null) {
            this.mUserName = this.mPreferences.get(USER_NAME, null);
        }
        return this.mUserName;
    }

    public void setUserName(String username) {
        this.mUserName = username;
        if (this.mUserName == null) {
            this.mPreferences.remove(USER_NAME);
        } else {
            this.mPreferences.put(USER_NAME, this.mUserName);
        }
        this.notifyPreferenceUpdated();
    }

    public String getPassword() {
        if (this.mPassword == null) {
            this.mPassword = this.mPreferences.get(PASSWORD, null);
        }
        return this.mPassword;
    }

    public void setPassword(String password) {
        this.mPassword = password;
        if (this.mPassword == null) {
            this.mPreferences.remove(PASSWORD);
        } else {
            this.mPreferences.put(PASSWORD, this.mPassword);
        }
        this.notifyPreferenceUpdated();
    }

    public boolean isStoreCredentials() {
        if (this.mStoreCredentials == null) {
            this.mStoreCredentials = this.mPreferences.getBoolean(STORE_CREDENTIALS, true);
        }
        return this.mStoreCredentials;
    }

    public void setStoreCredentials(boolean store) {
        this.mStoreCredentials = store;
        this.mPreferences.putBoolean(STORE_CREDENTIALS, store);
        this.notifyPreferenceUpdated();
    }

    public boolean getShowPassword() {
        if (this.mShowPassword == null) {
            this.mShowPassword = this.mPreferences.getBoolean(SHOW_PASSWORD, false);
        }
        return this.mShowPassword;
    }

    public void setShowPassword(boolean show) {
        this.mShowPassword = show;
        this.mPreferences.putBoolean(SHOW_PASSWORD, show);
        this.notifyPreferenceUpdated();
    }

    public int getPreferredCountryId() {
        if (this.mPreferredCountryId < 0) {
            this.mPreferredCountryId = this.mPreferences.getInt(PREFERRED_COUNTRY_ID, -1);
        }
        return this.mPreferredCountryId;
    }

    public void setPreferredCountryId(int countryId) {
        this.mPreferredCountryId = countryId;
        this.mPreferences.putInt(PREFERRED_COUNTRY_ID, countryId);
        this.notifyPreferenceUpdated();
    }

    public int getPreferredStateId() {
        if (this.mPreferredStateId < 0) {
            this.mPreferredStateId = this.mPreferences.getInt(PREFERRED_STATE_ID, -1);
        }
        return this.mPreferredStateId;
    }

    public void setPreferredStateId(int state) {
        this.mPreferredStateId = state;
        this.mPreferences.putInt(PREFERRED_STATE_ID, this.mPreferredStateId);
        this.notifyPreferenceUpdated();
    }

    public int getPreferredCountyId() {
        if (this.mPreferredCountyId < 0) {
            this.mPreferredCountyId = this.mPreferences.getInt(PREFERRED_COUNTY_ID, -1);
        }
        return this.mPreferredCountyId;
    }

    public void setPreferredCountyId(int county) {
        this.mPreferredCountyId = county;
        this.mPreferences.putInt(PREFERRED_COUNTY_ID, this.mPreferredCountyId);
        this.notifyPreferenceUpdated();
    }

    public int getPreferredSystemId(Level level) {
        switch (level) {
            case STATE: {
                if (this.mPreferredSystemIdState < 0) {
                    this.mPreferredSystemIdState = this.mPreferences.getInt(PREFERRED_SYSTEM_ID_STATE, -1);
                }
                return this.mPreferredSystemIdState;
            }
        }
        if (this.mPreferredSystemIdCounty < 0) {
            this.mPreferredSystemIdCounty = this.mPreferences.getInt(PREFERRED_SYSTEM_ID_COUNTY, -1);
        }
        return this.mPreferredSystemIdCounty;
    }

    public void setPreferredSystemId(int systemId, Level level) {
        switch (level) {
            case STATE: {
                this.mPreferredSystemIdState = systemId;
                this.mPreferences.putInt(PREFERRED_SYSTEM_ID_STATE, this.mPreferredSystemIdState);
                this.notifyPreferenceUpdated();
                break;
            }
            default: {
                this.mPreferredSystemIdCounty = systemId;
                this.mPreferences.putInt(PREFERRED_SYSTEM_ID_COUNTY, this.mPreferredSystemIdCounty);
                this.notifyPreferenceUpdated();
            }
        }
    }

    public int getPreferredAgencyId(Level level) {
        switch (level) {
            case NATIONAL: {
                if (this.mPreferredAgencyIdNational < 0) {
                    this.mPreferredAgencyIdNational = this.mPreferences.getInt(PREFERRED_AGENCY_ID_NATIONAL, -1);
                }
                return this.mPreferredAgencyIdNational;
            }
            case STATE: {
                if (this.mPreferredAgencyIdState < 0) {
                    this.mPreferredAgencyIdState = this.mPreferences.getInt(PREFERRED_AGENCY_ID_STATE, -1);
                }
                return this.mPreferredAgencyIdState;
            }
        }
        if (this.mPreferredAgencyIdCounty < 0) {
            this.mPreferredAgencyIdCounty = this.mPreferences.getInt(PREFERRED_AGENCY_ID_COUNTY, -1);
        }
        return this.mPreferredAgencyIdCounty;
    }

    public void setPreferredAgencyId(int agencyId, Level level) {
        switch (level) {
            case NATIONAL: {
                this.mPreferredAgencyIdNational = agencyId;
                this.mPreferences.putInt(PREFERRED_AGENCY_ID_NATIONAL, this.mPreferredAgencyIdNational);
                this.notifyPreferenceUpdated();
                break;
            }
            case STATE: {
                this.mPreferredAgencyIdState = agencyId;
                this.mPreferences.putInt(PREFERRED_AGENCY_ID_STATE, this.mPreferredAgencyIdState);
                this.notifyPreferenceUpdated();
                break;
            }
            default: {
                this.mPreferredAgencyIdCounty = agencyId;
                this.mPreferences.putInt(PREFERRED_AGENCY_ID_COUNTY, this.mPreferredAgencyIdCounty);
                this.notifyPreferenceUpdated();
            }
        }
    }

    public boolean getShowChannelEditor(Level level) {
        switch (level) {
            case NATIONAL: {
                if (this.mShowChannelEditorNational == null) {
                    this.mShowChannelEditorNational = this.mPreferences.getBoolean(SHOW_CHANNEL_EDITOR_NATIONAL, true);
                }
                return this.mShowChannelEditorNational;
            }
            case STATE: {
                if (this.mShowChannelEditorState == null) {
                    this.mShowChannelEditorState = this.mPreferences.getBoolean(SHOW_CHANNEL_EDITOR_STATE, true);
                }
                return this.mShowChannelEditorState;
            }
        }
        if (this.mShowChannelEditorCounty == null) {
            this.mShowChannelEditorCounty = this.mPreferences.getBoolean(SHOW_CHANNEL_EDITOR_COUNTY, true);
        }
        return this.mShowChannelEditorCounty;
    }

    public void setShowChannelEditor(boolean show, Level level) {
        switch (level) {
            case NATIONAL: {
                this.mShowChannelEditorNational = show;
                this.mPreferences.putBoolean(SHOW_CHANNEL_EDITOR_NATIONAL, this.mShowChannelEditorNational);
                this.notifyPreferenceUpdated();
                break;
            }
            case STATE: {
                this.mShowChannelEditorState = show;
                this.mPreferences.putBoolean(SHOW_CHANNEL_EDITOR_STATE, this.mShowChannelEditorState);
                this.notifyPreferenceUpdated();
                break;
            }
            default: {
                this.mShowChannelEditorCounty = show;
                this.mPreferences.putBoolean(SHOW_CHANNEL_EDITOR_COUNTY, this.mShowChannelEditorCounty);
                this.notifyPreferenceUpdated();
            }
        }
    }

    public boolean isEncryptedTalkgroupDoNotMonitor() {
        if (this.mEncryptedTalkgroupImport == null) {
            this.mEncryptedTalkgroupImport = this.mPreferences.getBoolean(ENCRYPTED_TALKGROUP_DO_NOT_MONITOR, true);
        }
        return this.mEncryptedTalkgroupImport;
    }

    public void setEncryptedTalkgroupDoNotMonitor(boolean doNotMonitor) {
        this.mEncryptedTalkgroupImport = doNotMonitor;
        this.mPreferences.putBoolean(ENCRYPTED_TALKGROUP_DO_NOT_MONITOR, doNotMonitor);
        this.notifyPreferenceUpdated();
    }

    public boolean isCreateAndShowChannelEditor() {
        if (this.mCreateAndShowChannelEditor == null) {
            this.mCreateAndShowChannelEditor = this.mPreferences.getBoolean(CREATE_AND_SHOW_CHANNEL_EDITOR, true);
        }
        return this.mCreateAndShowChannelEditor;
    }

    public void setCreateAndShowChannelEditor(boolean show) {
        this.mCreateAndShowChannelEditor = show;
        this.mPreferences.putBoolean(CREATE_AND_SHOW_CHANNEL_EDITOR, show);
        this.notifyPreferenceUpdated();
    }
}

