/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.preference.playback;

import io.github.dsheirer.gui.preference.playback.ToneFrequency;
import io.github.dsheirer.gui.preference.playback.ToneUtil;
import io.github.dsheirer.gui.preference.playback.ToneVolume;
import io.github.dsheirer.preference.Preference;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.mixer.MixerChannelConfiguration;
import io.github.dsheirer.source.mixer.MixerManager;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaybackPreference
extends Preference {
    private static final String PREFERENCE_KEY_USE_AUDIO_SEGMENT_DROP_TONE = "audio.playback.segment.drop.tone";
    private static final String PREFERENCE_KEY_DROP_TONE_FREQUENCY = "audio.playback.segment.drop.frequency";
    private static final String PREFERENCE_KEY_DROP_TONE_VOLUME = "audio.playback.segment.drop.volume";
    private static final String PREFERENCE_KEY_USE_AUDIO_SEGMENT_START_TONE = "audio.playback.segment.start.tone";
    private static final String PREFERENCE_KEY_START_TONE_FREQUENCY = "audio.playback.segment.start.frequency";
    private static final String PREFERENCE_KEY_START_TONE_VOLUME = "audio.playback.segment.start.volume";
    private static final String PREFERENCE_KEY_MIXER_CHANNEL_CONFIG = "audio.playback.mixer.channel.configuration";
    private static final int TONE_LENGTH_SAMPLES = 180;
    private static final Logger mLog = LoggerFactory.getLogger(PlaybackPreference.class);
    private Preferences mPreferences = Preferences.userNodeForPackage(PlaybackPreference.class);
    private Boolean mUseAudioSegmentStartTone;
    private Boolean mUseAudioSegmentDropTone;
    private ToneFrequency mStartToneFrequency;
    private ToneVolume mStartToneVolume;
    private ToneFrequency mDropToneFrequency;
    private ToneVolume mDropToneVolume;
    private MixerChannelConfiguration mMixerChannelConfiguration;

    public PlaybackPreference(Listener<PreferenceType> updateListener) {
        super(updateListener);
    }

    @Override
    public PreferenceType getPreferenceType() {
        return PreferenceType.PLAYBACK;
    }

    public boolean getUseAudioSegmentDropTone() {
        if (this.mUseAudioSegmentDropTone == null) {
            this.mUseAudioSegmentDropTone = this.mPreferences.getBoolean(PREFERENCE_KEY_USE_AUDIO_SEGMENT_DROP_TONE, true);
        }
        return this.mUseAudioSegmentDropTone;
    }

    public void setUseAudioSegmentDropTone(boolean use) {
        this.mUseAudioSegmentDropTone = use;
        this.mPreferences.putBoolean(PREFERENCE_KEY_USE_AUDIO_SEGMENT_DROP_TONE, use);
        this.notifyPreferenceUpdated();
    }

    public boolean getUseAudioSegmentStartTone() {
        if (this.mUseAudioSegmentStartTone == null) {
            this.mUseAudioSegmentStartTone = this.mPreferences.getBoolean(PREFERENCE_KEY_USE_AUDIO_SEGMENT_START_TONE, true);
        }
        return this.mUseAudioSegmentStartTone;
    }

    public void setUseAudioSegmentStartTone(boolean use) {
        this.mUseAudioSegmentStartTone = use;
        this.mPreferences.putBoolean(PREFERENCE_KEY_USE_AUDIO_SEGMENT_START_TONE, use);
        this.notifyPreferenceUpdated();
    }

    public ToneFrequency getDropToneFrequency() {
        if (this.mDropToneFrequency == null) {
            int frequency = this.mPreferences.getInt(PREFERENCE_KEY_DROP_TONE_FREQUENCY, ToneFrequency.F500.getValue());
            this.mDropToneFrequency = ToneFrequency.fromValue(frequency);
        }
        return this.mDropToneFrequency;
    }

    public void setDropToneFrequency(ToneFrequency toneFrequency) {
        this.mDropToneFrequency = toneFrequency;
        this.mPreferences.putInt(PREFERENCE_KEY_DROP_TONE_FREQUENCY, toneFrequency.getValue());
        this.notifyPreferenceUpdated();
    }

    public ToneFrequency getStartToneFrequency() {
        if (this.mStartToneFrequency == null) {
            int frequency = this.mPreferences.getInt(PREFERENCE_KEY_START_TONE_FREQUENCY, ToneFrequency.F700.getValue());
            this.mStartToneFrequency = ToneFrequency.fromValue(frequency);
        }
        return this.mStartToneFrequency;
    }

    public void setStartToneFrequency(ToneFrequency toneFrequency) {
        this.mStartToneFrequency = toneFrequency;
        this.mPreferences.putInt(PREFERENCE_KEY_START_TONE_FREQUENCY, toneFrequency.getValue());
        this.notifyPreferenceUpdated();
    }

    public ToneVolume getDropToneVolume() {
        if (this.mDropToneVolume == null) {
            int volume = this.mPreferences.getInt(PREFERENCE_KEY_DROP_TONE_VOLUME, ToneVolume.V3.getValue());
            this.mDropToneVolume = ToneVolume.fromValue(volume);
        }
        return this.mDropToneVolume;
    }

    public void setDropToneVolume(ToneVolume toneVolume) {
        this.mDropToneVolume = toneVolume;
        this.mPreferences.putInt(PREFERENCE_KEY_DROP_TONE_VOLUME, toneVolume.getValue());
        this.notifyPreferenceUpdated();
    }

    public ToneVolume getStartToneVolume() {
        if (this.mStartToneVolume == null) {
            int volume = this.mPreferences.getInt(PREFERENCE_KEY_START_TONE_VOLUME, ToneVolume.V3.getValue());
            this.mStartToneVolume = ToneVolume.fromValue(volume);
        }
        return this.mStartToneVolume;
    }

    public void setStartToneVolume(ToneVolume toneVolume) {
        this.mStartToneVolume = toneVolume;
        this.mPreferences.putInt(PREFERENCE_KEY_START_TONE_VOLUME, toneVolume.getValue());
        this.notifyPreferenceUpdated();
    }

    public float[] getStartTone() {
        if (this.getUseAudioSegmentStartTone()) {
            return ToneUtil.getTone(this.getStartToneFrequency(), this.getStartToneVolume(), 180);
        }
        return null;
    }

    public float[] getDropTone() {
        if (this.getUseAudioSegmentDropTone()) {
            return ToneUtil.getTone(this.getDropToneFrequency(), this.getDropToneVolume(), 180);
        }
        return null;
    }

    public float[] getMixerTestTone() {
        return ToneUtil.getTone(ToneFrequency.F1200, ToneVolume.V10, 800);
    }

    public MixerChannelConfiguration getMixerChannelConfiguration() {
        if (this.mMixerChannelConfiguration == null) {
            MixerChannelConfiguration defaultConfig = MixerManager.getDefaultOutputMixer();
            if (defaultConfig != null) {
                String configName = this.mPreferences.get(PREFERENCE_KEY_MIXER_CHANNEL_CONFIG, defaultConfig.toString());
                for (MixerChannelConfiguration config : MixerManager.getOutputMixers()) {
                    if (!config.toString().contentEquals(configName)) continue;
                    this.mMixerChannelConfiguration = config;
                }
                if (this.mMixerChannelConfiguration == null) {
                    this.mMixerChannelConfiguration = defaultConfig;
                }
            } else {
                mLog.error("Error - no system audio devices available");
            }
        }
        return this.mMixerChannelConfiguration;
    }

    public void setMixerChannelConfiguration(MixerChannelConfiguration configuration) {
        this.mMixerChannelConfiguration = configuration;
        this.mPreferences.put(PREFERENCE_KEY_MIXER_CHANNEL_CONFIG, configuration.toString());
        this.notifyPreferenceUpdated();
    }
}

