/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.preference.identifier.talkgroup;

import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.module.decode.fleetsync2.identifier.FleetsyncIdentifier;
import io.github.dsheirer.preference.identifier.IntegerFormat;
import io.github.dsheirer.preference.identifier.talkgroup.AbstractIntegerFormatter;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FleetsyncTalkgroupFormatter
extends AbstractIntegerFormatter {
    private static final Logger mLog = LoggerFactory.getLogger(FleetsyncTalkgroupFormatter.class);
    private static final int IDENTIFIER_DECIMAL_WIDTH = 7;
    private static final int IDENTIFIER_HEXADECIMAL_WIDTH = 5;
    private static final int FLEET_DECIMAL_WIDTH = 3;
    private static final int IDENT_DECIMAL_WIDTH = 4;
    private static final String SEPARATOR = "-";
    private static final Pattern FLEETSYNC_PATTERN = Pattern.compile("(\\d{1,3})-(\\d{1,4})");

    public static String format(TalkgroupIdentifier identifier, IntegerFormat format, boolean fixedWidth) {
        if (identifier instanceof FleetsyncIdentifier) {
            FleetsyncIdentifier fleetsync = (FleetsyncIdentifier)identifier;
            if (fixedWidth) {
                switch (format) {
                    case DECIMAL: {
                        return FleetsyncTalkgroupFormatter.toDecimal((Integer)fleetsync.getValue(), 7);
                    }
                    case FORMATTED: {
                        return FleetsyncTalkgroupFormatter.toDecimal(fleetsync.getFleet(), 3) + SEPARATOR + FleetsyncTalkgroupFormatter.toDecimal(fleetsync.getIdent(), 4);
                    }
                    case HEXADECIMAL: {
                        return FleetsyncTalkgroupFormatter.toHex((Integer)fleetsync.getValue(), 5);
                    }
                }
                throw new IllegalArgumentException("Unrecognized integer format: " + String.valueOf((Object)format));
            }
            switch (format) {
                case DECIMAL: {
                    return fleetsync.toString();
                }
                case FORMATTED: {
                    return fleetsync.getFleet() + SEPARATOR + fleetsync.getIdent();
                }
                case HEXADECIMAL: {
                    return FleetsyncTalkgroupFormatter.toHex((Integer)identifier.getValue());
                }
            }
            throw new IllegalArgumentException("Unrecognized integer format: " + String.valueOf((Object)format));
        }
        return identifier.toString();
    }

    @Override
    public String format(int talkgroup) {
        return FleetsyncTalkgroupFormatter.toDecimal(FleetsyncTalkgroupFormatter.getPrefix(talkgroup), 3) + SEPARATOR + FleetsyncTalkgroupFormatter.toDecimal(FleetsyncTalkgroupFormatter.getIdent(talkgroup), 4);
    }

    @Override
    public int parse(String formattedTalkgroup) throws ParseException {
        Matcher m;
        if (formattedTalkgroup != null && (m = FLEETSYNC_PATTERN.matcher(formattedTalkgroup)).matches()) {
            String rawPrefix = m.group(1);
            String rawIdent = m.group(2);
            try {
                int prefix = Integer.parseInt(rawPrefix);
                if (prefix < 1 || prefix > 127) {
                    throw new ParseException("Fleetsync prefix must be in range 1-127.  Error parsing [" + formattedTalkgroup + "]", 0);
                }
                int ident = Integer.parseInt(rawIdent);
                if (ident < 1 || ident > 8191) {
                    throw new ParseException("Fleetsync ident must be in range 1-8192.  Error parsing [" + formattedTalkgroup + "]", 0);
                }
                return (prefix << 13) + ident;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new ParseException("Error parsing value from fleetsync talkgroup [" + formattedTalkgroup + "]", 0);
    }

    @Override
    public String format(int value, IntegerFormat format) {
        return this.format(value);
    }

    public static int getPrefix(int talkgroup) {
        return talkgroup >> 13 & 0x7F;
    }

    public static int getIdent(int talkgroup) {
        return talkgroup & 0x1FFF;
    }
}

