/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.preference.identifier.talkgroup;

import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.preference.identifier.IntegerFormat;
import io.github.dsheirer.preference.identifier.talkgroup.AbstractIntegerFormatter;

public class DMRTalkgroupFormatter
extends AbstractIntegerFormatter {
    public static final int GROUP_DECIMAL_WIDTH = 8;
    public static final int UNIT_DECIMAL_WIDTH = 8;
    public static final int GROUP_HEXADECIMAL_WIDTH = 6;
    public static final int UNIT_HEXADECIMAL_WIDTH = 6;

    public static String format(TalkgroupIdentifier identifier, IntegerFormat format, boolean fixedWidth) {
        if (fixedWidth) {
            switch (format) {
                case DECIMAL: 
                case FORMATTED: {
                    return DMRTalkgroupFormatter.toDecimal((Integer)identifier.getValue(), 8);
                }
                case HEXADECIMAL: {
                    return DMRTalkgroupFormatter.toHex((Integer)identifier.getValue(), 6);
                }
            }
            throw new IllegalArgumentException("Unrecognized integer format: " + String.valueOf((Object)format));
        }
        switch (format) {
            case DECIMAL: 
            case FORMATTED: {
                return ((Integer)identifier.getValue()).toString();
            }
            case HEXADECIMAL: {
                return DMRTalkgroupFormatter.toHex((Integer)identifier.getValue());
            }
        }
        throw new IllegalArgumentException("Unrecognized integer format: " + String.valueOf((Object)format));
    }

    public static String format(RadioIdentifier identifier, IntegerFormat format, boolean fixedWidth) {
        if (fixedWidth) {
            switch (format) {
                case DECIMAL: 
                case FORMATTED: {
                    return DMRTalkgroupFormatter.toDecimal((Integer)identifier.getValue(), 8);
                }
                case HEXADECIMAL: {
                    return DMRTalkgroupFormatter.toHex((Integer)identifier.getValue(), 6);
                }
            }
            throw new IllegalArgumentException("Unrecognized integer format: " + String.valueOf((Object)format));
        }
        switch (format) {
            case DECIMAL: 
            case FORMATTED: {
                return ((Integer)identifier.getValue()).toString();
            }
            case HEXADECIMAL: {
                return DMRTalkgroupFormatter.toHex((Integer)identifier.getValue());
            }
        }
        throw new IllegalArgumentException("Unrecognized integer format: " + String.valueOf((Object)format));
    }

    @Override
    public String format(int value, IntegerFormat integerFormat) {
        switch (integerFormat) {
            case DECIMAL: 
            case FORMATTED: {
                return this.format(value);
            }
            case HEXADECIMAL: {
                return DMRTalkgroupFormatter.toHex(value);
            }
        }
        throw new IllegalArgumentException("Unrecognized integer format: " + String.valueOf((Object)integerFormat));
    }
}

