/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.preference.identifier.talkgroup;

import io.github.dsheirer.identifier.patch.PatchGroup;
import io.github.dsheirer.identifier.patch.PatchGroupIdentifier;
import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.preference.identifier.IntegerFormat;
import io.github.dsheirer.preference.identifier.talkgroup.AbstractIntegerFormatter;

public class APCO25TalkgroupFormatter
extends AbstractIntegerFormatter {
    public static final int GROUP_DECIMAL_WIDTH = 5;
    public static final int UNIT_DECIMAL_WIDTH = 8;
    public static final int GROUP_HEXADECIMAL_WIDTH = 4;
    public static final int UNIT_HEXADECIMAL_WIDTH = 6;

    public static String format(TalkgroupIdentifier identifier, IntegerFormat format, boolean fixedWidth) {
        if (fixedWidth) {
            switch (format) {
                case DECIMAL: 
                case FORMATTED: {
                    return APCO25TalkgroupFormatter.toDecimal((Integer)identifier.getValue(), 5);
                }
                case HEXADECIMAL: {
                    return APCO25TalkgroupFormatter.toHex((Integer)identifier.getValue(), 4);
                }
            }
            throw new IllegalArgumentException("Unrecognized integer format: " + String.valueOf((Object)format));
        }
        switch (format) {
            case DECIMAL: 
            case FORMATTED: {
                return ((Integer)identifier.getValue()).toString();
            }
            case HEXADECIMAL: {
                return APCO25TalkgroupFormatter.toHex((Integer)identifier.getValue());
            }
        }
        throw new IllegalArgumentException("Unrecognized integer format: " + String.valueOf((Object)format));
    }

    public static String format(PatchGroupIdentifier identifier, IntegerFormat format, boolean fixedWidth) {
        PatchGroup patchGroup = (PatchGroup)identifier.getValue();
        if (patchGroup != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("P:");
            sb.append(APCO25TalkgroupFormatter.format(patchGroup.getPatchGroup(), format, fixedWidth));
            sb.append("[");
            int counter = 0;
            for (TalkgroupIdentifier patchedGroup : patchGroup.getPatchedTalkgroupIdentifiers()) {
                sb.append(APCO25TalkgroupFormatter.format(patchedGroup, format, fixedWidth));
                if (counter++ >= patchGroup.getPatchedTalkgroupIdentifiers().size() - 1) continue;
                sb.append(",");
            }
            counter = 0;
            for (RadioIdentifier patchedRadio : patchGroup.getPatchedRadioIdentifiers()) {
                sb.append(APCO25TalkgroupFormatter.format(patchedRadio, format, fixedWidth));
                if (counter++ >= patchGroup.getPatchedRadioIdentifiers().size() - 1) continue;
                sb.append(",");
            }
            sb.append("]");
            return sb.toString();
        }
        return identifier.toString();
    }

    public static String format(RadioIdentifier identifier, IntegerFormat format, boolean fixedWidth) {
        if (fixedWidth) {
            switch (format) {
                case DECIMAL: 
                case FORMATTED: {
                    return APCO25TalkgroupFormatter.toDecimal((Integer)identifier.getValue(), 8);
                }
                case HEXADECIMAL: {
                    return APCO25TalkgroupFormatter.toHex((Integer)identifier.getValue(), 6);
                }
            }
            throw new IllegalArgumentException("Unrecognized integer format: " + String.valueOf((Object)format));
        }
        switch (format) {
            case DECIMAL: 
            case FORMATTED: {
                return ((Integer)identifier.getValue()).toString();
            }
            case HEXADECIMAL: {
                return APCO25TalkgroupFormatter.toHex((Integer)identifier.getValue());
            }
        }
        throw new IllegalArgumentException("Unrecognized integer format: " + String.valueOf((Object)format));
    }

    @Override
    public String format(int value, IntegerFormat integerFormat) {
        switch (integerFormat) {
            case DECIMAL: 
            case FORMATTED: {
                return this.format(value);
            }
            case HEXADECIMAL: {
                return APCO25TalkgroupFormatter.toHex(value);
            }
        }
        throw new IllegalArgumentException("Unrecognized integer format: " + String.valueOf((Object)integerFormat));
    }
}

