/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.preference.event;

import io.github.dsheirer.preference.Preference;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.preference.TimestampFormat;
import io.github.dsheirer.sample.Listener;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecodeEventPreference
extends Preference {
    private static final Logger mLog = LoggerFactory.getLogger(DecodeEventPreference.class);
    private Preferences mPreferences = Preferences.userNodeForPackage(DecodeEventPreference.class);
    private TimestampFormat mTimestampFormat = TimestampFormat.TIMESTAMP_DEFAULT;
    private static final String TIMESTAMP_FORMAT_KEY = "timestamp.format";

    public DecodeEventPreference(Listener<PreferenceType> updateListener) {
        super(updateListener);
        this.loadSettings();
    }

    @Override
    public PreferenceType getPreferenceType() {
        return PreferenceType.DECODE_EVENT;
    }

    private void loadSettings() {
        String format = this.mPreferences.get(TIMESTAMP_FORMAT_KEY, TimestampFormat.TIMESTAMP_COLONS.name());
        if (format != null && !format.isEmpty()) {
            try {
                this.mTimestampFormat = TimestampFormat.valueOf(format);
            }
            catch (Exception e) {
                mLog.error("Error loading decode event timestamp format [" + format + "]");
            }
        }
    }

    public TimestampFormat getTimestampFormat() {
        return this.mTimestampFormat;
    }

    public void setTimestampFormat(TimestampFormat timestampFormat) {
        this.mTimestampFormat = timestampFormat;
        this.mPreferences.put(TIMESTAMP_FORMAT_KEY, this.mTimestampFormat.name());
        this.notifyPreferenceUpdated();
    }
}

