/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.preference.duplicate;

import io.github.dsheirer.preference.Preference;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.sample.Listener;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateCallDetectionPreference
extends Preference {
    private static final String PREFERENCE_KEY_DETECT_DUPLICATE_TALKGROUP = "duplicate.call.detect.talkgroup";
    private static final String PREFERENCE_KEY_DETECT_DUPLICATE_RADIO = "duplicate.call.detect.radio";
    private static final String PREFERENCE_KEY_SUPPRESS_DUPLICATE_PLAYBACK = "suppress.duplicate.audio.playback";
    private static final String PREFERENCE_KEY_SUPPRESS_DUPLICATE_RECORDING = "suppress.duplicate.audio.recording";
    private static final String PREFERENCE_KEY_SUPPRESS_DUPLICATE_STREAMING = "suppress.duplicate.audio.streaming";
    private static final Logger mLog = LoggerFactory.getLogger(DuplicateCallDetectionPreference.class);
    private Preferences mPreferences = Preferences.userNodeForPackage(DuplicateCallDetectionPreference.class);
    private Boolean mDuplicateCallDetectionByTalkgroupEnabled;
    private Boolean mDuplicateCallDetectionByRadioEnabled;
    private Boolean mDuplicatePlaybackSuppressionEnabled;
    private Boolean mDuplicateRecordingSuppressionEnabled;
    private Boolean mDuplicateStreamingSuppressionEnabled;

    public DuplicateCallDetectionPreference(Listener<PreferenceType> updateListener) {
        super(updateListener);
    }

    @Override
    public PreferenceType getPreferenceType() {
        return PreferenceType.DUPLICATE_CALL_DETECTION;
    }

    public boolean isDuplicateCallDetectionEnabled() {
        return this.isDuplicateCallDetectionByTalkgroupEnabled() || this.isDuplicateCallDetectionByRadioEnabled();
    }

    public boolean isDuplicateCallDetectionByTalkgroupEnabled() {
        if (this.mDuplicateCallDetectionByTalkgroupEnabled == null) {
            this.mDuplicateCallDetectionByTalkgroupEnabled = this.mPreferences.getBoolean(PREFERENCE_KEY_DETECT_DUPLICATE_TALKGROUP, true);
        }
        return this.mDuplicateCallDetectionByTalkgroupEnabled;
    }

    public void setDuplicateCallDetectionByTalkgroupEnabled(boolean enabled) {
        this.mPreferences.putBoolean(PREFERENCE_KEY_DETECT_DUPLICATE_TALKGROUP, enabled);
        this.mDuplicateCallDetectionByTalkgroupEnabled = enabled;
        this.notifyPreferenceUpdated();
    }

    public boolean isDuplicateCallDetectionByRadioEnabled() {
        if (this.mDuplicateCallDetectionByRadioEnabled == null) {
            this.mDuplicateCallDetectionByRadioEnabled = this.mPreferences.getBoolean(PREFERENCE_KEY_DETECT_DUPLICATE_RADIO, false);
        }
        return this.mDuplicateCallDetectionByRadioEnabled;
    }

    public void setDuplicateCallDetectionByRadioEnabled(boolean enabled) {
        this.mPreferences.putBoolean(PREFERENCE_KEY_DETECT_DUPLICATE_RADIO, enabled);
        this.mDuplicateCallDetectionByRadioEnabled = enabled;
        this.notifyPreferenceUpdated();
    }

    public boolean isDuplicatePlaybackSuppressionEnabled() {
        if (this.mDuplicatePlaybackSuppressionEnabled == null) {
            this.mDuplicatePlaybackSuppressionEnabled = this.mPreferences.getBoolean(PREFERENCE_KEY_SUPPRESS_DUPLICATE_PLAYBACK, true);
        }
        return this.mDuplicatePlaybackSuppressionEnabled;
    }

    public void setDuplicatePlaybackSuppressionEnabled(boolean enabled) {
        this.mPreferences.putBoolean(PREFERENCE_KEY_SUPPRESS_DUPLICATE_PLAYBACK, enabled);
        this.mDuplicatePlaybackSuppressionEnabled = enabled;
        this.notifyPreferenceUpdated();
    }

    public boolean isDuplicateRecordingSuppressionEnabled() {
        if (this.mDuplicateRecordingSuppressionEnabled == null) {
            this.mDuplicateRecordingSuppressionEnabled = this.mPreferences.getBoolean(PREFERENCE_KEY_SUPPRESS_DUPLICATE_RECORDING, true);
        }
        return this.mDuplicateRecordingSuppressionEnabled;
    }

    public void setDuplicateRecordingSuppressionEnabled(boolean enabled) {
        this.mPreferences.putBoolean(PREFERENCE_KEY_SUPPRESS_DUPLICATE_RECORDING, enabled);
        this.mDuplicateRecordingSuppressionEnabled = enabled;
        this.notifyPreferenceUpdated();
    }

    public boolean isDuplicateStreamingSuppressionEnabled() {
        if (this.mDuplicateStreamingSuppressionEnabled == null) {
            this.mDuplicateStreamingSuppressionEnabled = this.mPreferences.getBoolean(PREFERENCE_KEY_SUPPRESS_DUPLICATE_STREAMING, true);
        }
        return this.mDuplicateStreamingSuppressionEnabled;
    }

    public void setDuplicateStreamingSuppressionEnabled(boolean enabled) {
        this.mPreferences.putBoolean(PREFERENCE_KEY_SUPPRESS_DUPLICATE_STREAMING, enabled);
        this.mDuplicateStreamingSuppressionEnabled = enabled;
        this.notifyPreferenceUpdated();
    }
}

