/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.preference.decoder;

import io.github.dsheirer.jmbe.github.Version;
import io.github.dsheirer.preference.Preference;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.sample.Listener;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmbeLibraryPreference
extends Preference {
    private static final Logger mLog = LoggerFactory.getLogger(JmbeLibraryPreference.class);
    private Preferences mPreferences = Preferences.userNodeForPackage(JmbeLibraryPreference.class);
    private static final String PREFERENCE_KEY_PATH_JMBE_LIBRARY = "path.jmbe.library.1.0.0";
    private static final String PREFERENCE_KEY_PATH_ALERT_LIBRARY_REQUIRED = "alert.jmbe.required";
    private final Pattern VERSION_PATTERN = Pattern.compile(".*jmbe-(\\d{1,5}.\\d{1,5}.\\d{1,5}\\w*)\\.jar");
    private Path mPathJmbeLibrary;
    private Boolean mAlertIfMissingLibraryRequired;

    public JmbeLibraryPreference(Listener<PreferenceType> updateListener) {
        super(updateListener);
    }

    @Override
    public PreferenceType getPreferenceType() {
        return PreferenceType.JMBE_LIBRARY;
    }

    public Version getCurrentVersion() {
        Matcher m;
        Path path = this.getPathJmbeLibrary();
        if (path != null && (m = this.VERSION_PATTERN.matcher(path.toString())).matches()) {
            return Version.fromString(m.group(1));
        }
        return null;
    }

    public Path getPathJmbeLibrary() {
        if (this.mPathJmbeLibrary == null) {
            this.mPathJmbeLibrary = this.getPath(PREFERENCE_KEY_PATH_JMBE_LIBRARY, null);
        }
        return this.mPathJmbeLibrary;
    }

    public boolean hasJmbeLibraryPath() {
        return this.getPathJmbeLibrary() != null;
    }

    public void setPathJmbeLibrary(Path path) {
        this.mPathJmbeLibrary = path;
        this.mPreferences.put(PREFERENCE_KEY_PATH_JMBE_LIBRARY, path.toString());
        this.notifyPreferenceUpdated();
    }

    public void resetPathJmbeLibrary() {
        this.mPreferences.remove(PREFERENCE_KEY_PATH_JMBE_LIBRARY);
        this.mPathJmbeLibrary = null;
        this.notifyPreferenceUpdated();
    }

    public boolean getAlertIfMissingLibraryRequired() {
        if (this.mAlertIfMissingLibraryRequired == null) {
            this.mAlertIfMissingLibraryRequired = this.mPreferences.getBoolean(PREFERENCE_KEY_PATH_ALERT_LIBRARY_REQUIRED, true);
        }
        return this.mAlertIfMissingLibraryRequired;
    }

    public void setAlertIfMissingLibraryRequired(boolean alert) {
        this.mAlertIfMissingLibraryRequired = alert;
        this.mPreferences.putBoolean(PREFERENCE_KEY_PATH_ALERT_LIBRARY_REQUIRED, this.mAlertIfMissingLibraryRequired);
        this.notifyPreferenceUpdated();
    }

    private Path getPath(String key, Path defaultPath) {
        Path temp;
        String stringPath = this.mPreferences.get(key, defaultPath != null ? defaultPath.toString() : null);
        if (stringPath != null && !stringPath.isEmpty() && Files.exists(temp = Paths.get(stringPath, new String[0]), new LinkOption[0])) {
            return temp;
        }
        return defaultPath;
    }
}

