/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.preference.calibration;

import io.github.dsheirer.preference.Preference;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.sample.Listener;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorCalibrationPreference
extends Preference {
    private static final String PREFERENCE_KEY_HIDE_CALIBRATION_DIALOG = "hide.calibration.dialog";
    private static final String PREFERENCE_KEY_VECTOR_ENABLED = "vector.enabled";
    private static final Logger mLog = LoggerFactory.getLogger(VectorCalibrationPreference.class);
    private Preferences mPreferences = Preferences.userNodeForPackage(VectorCalibrationPreference.class);
    private Boolean mVectorEnabled;
    private Boolean mHideCalibrationDialog;

    public VectorCalibrationPreference(Listener<PreferenceType> updateListener) {
        super(updateListener);
    }

    @Override
    public PreferenceType getPreferenceType() {
        return PreferenceType.CALIBRATION;
    }

    public boolean isHideCalibrationDialog() {
        if (this.mHideCalibrationDialog == null) {
            this.mHideCalibrationDialog = this.mPreferences.getBoolean(PREFERENCE_KEY_HIDE_CALIBRATION_DIALOG, false);
        }
        return this.mHideCalibrationDialog;
    }

    public void setHideCalibrationDialog(boolean hide) {
        this.mPreferences.putBoolean(PREFERENCE_KEY_HIDE_CALIBRATION_DIALOG, hide);
        this.mHideCalibrationDialog = hide;
        this.notifyPreferenceUpdated();
    }

    public boolean isVectorEnabled() {
        if (this.mVectorEnabled == null) {
            this.mVectorEnabled = this.mPreferences.getBoolean(PREFERENCE_KEY_VECTOR_ENABLED, true);
        }
        return this.mVectorEnabled;
    }

    public void setVectorEnabled(boolean enabled) {
        this.mPreferences.putBoolean(PREFERENCE_KEY_VECTOR_ENABLED, enabled);
        this.mVectorEnabled = enabled;
        this.notifyPreferenceUpdated();
    }
}

