/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.preference.application;

import io.github.dsheirer.preference.Preference;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.sample.Listener;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationPreference
extends Preference {
    private static final String PREFERENCE_KEY_CHANNEL_AUTO_START_TIMEOUT = "channel.auto.start.timeout";
    private static final Logger mLog = LoggerFactory.getLogger(ApplicationPreference.class);
    private Preferences mPreferences = Preferences.userNodeForPackage(ApplicationPreference.class);
    private Integer mChannelAutoStartTimeout;

    public ApplicationPreference(Listener<PreferenceType> updateListener) {
        super(updateListener);
    }

    @Override
    public PreferenceType getPreferenceType() {
        return PreferenceType.APPLICATION;
    }

    public int getChannelAutoStartTimeout() {
        if (this.mChannelAutoStartTimeout == null) {
            this.mChannelAutoStartTimeout = this.mPreferences.getInt(PREFERENCE_KEY_CHANNEL_AUTO_START_TIMEOUT, 10);
        }
        return this.mChannelAutoStartTimeout;
    }

    public void setChannelAutoStartTimeout(int timeout) {
        this.mChannelAutoStartTimeout = timeout;
        this.mPreferences.putInt(PREFERENCE_KEY_CHANNEL_AUTO_START_TIMEOUT, timeout);
        this.notifyPreferenceUpdated();
    }
}

