/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.preference;

import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.preference.application.ApplicationPreference;
import io.github.dsheirer.preference.calibration.VectorCalibrationPreference;
import io.github.dsheirer.preference.decoder.JmbeLibraryPreference;
import io.github.dsheirer.preference.directory.DirectoryPreference;
import io.github.dsheirer.preference.duplicate.DuplicateCallDetectionPreference;
import io.github.dsheirer.preference.event.DecodeEventPreference;
import io.github.dsheirer.preference.identifier.TalkgroupFormatPreference;
import io.github.dsheirer.preference.javafx.JavaFxPreferences;
import io.github.dsheirer.preference.mp3.MP3Preference;
import io.github.dsheirer.preference.playback.PlaybackPreference;
import io.github.dsheirer.preference.playlist.PlaylistPreference;
import io.github.dsheirer.preference.radioreference.RadioReferencePreference;
import io.github.dsheirer.preference.record.RecordPreference;
import io.github.dsheirer.preference.source.ChannelMultiFrequencyPreference;
import io.github.dsheirer.preference.source.TunerPreference;
import io.github.dsheirer.preference.swing.SwingPreference;
import io.github.dsheirer.sample.Listener;

public class UserPreferences
implements Listener<PreferenceType> {
    private ApplicationPreference mApplicationPreference;
    private ChannelMultiFrequencyPreference mChannelMultiFrequencyPreference;
    private DecodeEventPreference mDecodeEventPreference;
    private DirectoryPreference mDirectoryPreference;
    private DuplicateCallDetectionPreference mDuplicateCallDetectionPreference;
    private JmbeLibraryPreference mJmbeLibraryPreference;
    private MP3Preference mMP3Preference;
    private PlaybackPreference mPlaybackPreference;
    private PlaylistPreference mPlaylistPreference;
    private RadioReferencePreference mRadioReferencePreference;
    private RecordPreference mRecordPreference;
    private TalkgroupFormatPreference mTalkgroupFormatPreference;
    private TunerPreference mTunerPreference;
    private VectorCalibrationPreference mVectorCalibrationPreference;
    private SwingPreference mSwingPreference = new SwingPreference();
    private JavaFxPreferences mJavaFxPreferences = new JavaFxPreferences();

    public UserPreferences() {
        this.loadPreferenceTypes();
    }

    public ApplicationPreference getApplicationPreference() {
        return this.mApplicationPreference;
    }

    public VectorCalibrationPreference getVectorCalibrationPreference() {
        return this.mVectorCalibrationPreference;
    }

    public JavaFxPreferences getJavaFxPreferences() {
        return this.mJavaFxPreferences;
    }

    public DecodeEventPreference getDecodeEventPreference() {
        return this.mDecodeEventPreference;
    }

    public JmbeLibraryPreference getJmbeLibraryPreference() {
        return this.mJmbeLibraryPreference;
    }

    public DirectoryPreference getDirectoryPreference() {
        return this.mDirectoryPreference;
    }

    public ChannelMultiFrequencyPreference getChannelMultiFrequencyPreference() {
        return this.mChannelMultiFrequencyPreference;
    }

    public PlaybackPreference getPlaybackPreference() {
        return this.mPlaybackPreference;
    }

    public PlaylistPreference getPlaylistPreference() {
        return this.mPlaylistPreference;
    }

    public RadioReferencePreference getRadioReferencePreference() {
        return this.mRadioReferencePreference;
    }

    public RecordPreference getRecordPreference() {
        return this.mRecordPreference;
    }

    public MP3Preference getMP3Preference() {
        return this.mMP3Preference;
    }

    public TalkgroupFormatPreference getTalkgroupFormatPreference() {
        return this.mTalkgroupFormatPreference;
    }

    public TunerPreference getTunerPreference() {
        return this.mTunerPreference;
    }

    public SwingPreference getSwingPreference() {
        return this.mSwingPreference;
    }

    public DuplicateCallDetectionPreference getDuplicateCallDetectionPreference() {
        return this.mDuplicateCallDetectionPreference;
    }

    private void loadPreferenceTypes() {
        this.mApplicationPreference = new ApplicationPreference(this::receive);
        this.mChannelMultiFrequencyPreference = new ChannelMultiFrequencyPreference(this::receive);
        this.mDecodeEventPreference = new DecodeEventPreference(this::receive);
        this.mDirectoryPreference = new DirectoryPreference(this::receive);
        this.mDuplicateCallDetectionPreference = new DuplicateCallDetectionPreference(this::receive);
        this.mJmbeLibraryPreference = new JmbeLibraryPreference(this::receive);
        this.mMP3Preference = new MP3Preference(this::receive);
        this.mPlaybackPreference = new PlaybackPreference(this::receive);
        this.mPlaylistPreference = new PlaylistPreference(this::receive, this.mDirectoryPreference);
        this.mRadioReferencePreference = new RadioReferencePreference(this::receive);
        this.mRecordPreference = new RecordPreference(this::receive);
        this.mTalkgroupFormatPreference = new TalkgroupFormatPreference(this::receive);
        this.mTunerPreference = new TunerPreference(this::receive);
        this.mVectorCalibrationPreference = new VectorCalibrationPreference(this::receive);
    }

    @Override
    public void receive(PreferenceType preferenceType) {
        MyEventBus.getGlobalEventBus().post((Object)preferenceType);
    }
}

