/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.playlist;

import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.id.AliasID;
import io.github.dsheirer.alias.id.AliasIDType;
import io.github.dsheirer.alias.id.legacy.fleetsync.FleetsyncID;
import io.github.dsheirer.alias.id.legacy.mdc.MDC1200ID;
import io.github.dsheirer.alias.id.legacy.mobileID.Min;
import io.github.dsheirer.alias.id.legacy.mpt1327.MPT1327ID;
import io.github.dsheirer.alias.id.legacy.talkgroup.LegacyTalkgroupID;
import io.github.dsheirer.alias.id.legacy.uniqueID.UniqueID;
import io.github.dsheirer.alias.id.radio.Radio;
import io.github.dsheirer.alias.id.radio.RadioRange;
import io.github.dsheirer.alias.id.talkgroup.Talkgroup;
import io.github.dsheirer.alias.id.talkgroup.TalkgroupRange;
import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.module.log.EventLogType;
import io.github.dsheirer.module.log.config.EventLogConfiguration;
import io.github.dsheirer.playlist.PlaylistV2;
import io.github.dsheirer.protocol.Protocol;
import io.github.dsheirer.record.RecorderType;
import io.github.dsheirer.record.config.RecordConfiguration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaylistUpdater {
    private static final Logger mLog = LoggerFactory.getLogger(PlaylistUpdater.class);
    private static final String APCO25_RADIO_ID = "[A-Fa-f\\d\\*]{6}";
    private static final String APCO25_TALKGROUP = "[A-Fa-f\\d\\*]{4}";
    private static final String FLEETSYNC_TALKGROUP = "(\\d{3})-(\\d{4})";
    private static final String LTR_TALKGROUP = "([\\d\\*]{1})-([\\d\\*]{2})-([\\d\\*]{3})";
    private static final String LTR_TALKGROUP_WILDCARD = "\\*-\\*{2}-([\\d]{3})";
    private static final String MDC1200_TALKGROUP = "[A-Fa-f\\d\\*]{4}";
    private static final String MOBILE_ID_NUMBER = "[A-Fa-f\\d\\*]{6}";
    private static final String MPT1327_TALKGROUP = "(\\d{3})-(\\d{4})";
    private static final String PASSPORT_TALKGROUP = "[\\d\\*]{5}";
    private static final Pattern FLEETSYNC_PATTERN = Pattern.compile("(\\d{3})-(\\d{4})");
    private static final Pattern LTR_PATTERN = Pattern.compile("([\\d\\*]{1})-([\\d\\*]{2})-([\\d\\*]{3})");
    private static final Pattern MPT1327_PATTERN = Pattern.compile("(\\d{3})-(\\d{4})");

    public static boolean update(PlaylistV2 playlist) {
        boolean updated = false;
        if (playlist.getVersion() != 4) {
            mLog.info("Updating Playlist from version [" + playlist.getVersion() + "] to version [4]");
        }
        switch (playlist.getVersion()) {
            case 1: 
            case 2: {
                PlaylistUpdater.removeVersion1AudioRecordType(playlist);
                PlaylistUpdater.removeVersion1BinaryMessageLogger(playlist);
                PlaylistUpdater.removeVersion1NonRecordableAliasIdentifiers(playlist);
                PlaylistUpdater.removeVersion1SiteIdentifiers(playlist);
                PlaylistUpdater.updateVersion1Talkgroups(playlist);
                updated = true;
            }
            case 3: {
                PlaylistUpdater.convertP25TalkgroupsToRadioIdentifiers(playlist);
                updated = true;
            }
        }
        return updated;
    }

    private static void convertP25TalkgroupsToRadioIdentifiers(PlaylistV2 playlist) {
        int converted = 0;
        for (Alias alias : playlist.getAliases()) {
            Iterator<AliasID> it = alias.getAliasIdentifiers().iterator();
            ArrayList<AliasID> convertedAliasIds = new ArrayList<AliasID>();
            AliasID id = null;
            while (it.hasNext()) {
                RadioRange radioRange;
                TalkgroupRange talkgroupRange;
                id = it.next();
                if (id instanceof Talkgroup) {
                    Talkgroup talkgroup = (Talkgroup)id;
                    if (talkgroup.getProtocol() != Protocol.APCO25 || talkgroup.getValue() <= 65535) continue;
                    it.remove();
                    Radio radio = new Radio();
                    radio.setProtocol(Protocol.APCO25);
                    radio.setValue(talkgroup.getValue());
                    convertedAliasIds.add(radio);
                    continue;
                }
                if (!(id instanceof TalkgroupRange) || (talkgroupRange = (TalkgroupRange)id).getProtocol() != Protocol.APCO25) continue;
                if (talkgroupRange.getMinTalkgroup() > 65535) {
                    it.remove();
                    radioRange = new RadioRange();
                    radioRange.setProtocol(Protocol.APCO25);
                    radioRange.setMinRadio(talkgroupRange.getMinTalkgroup());
                    radioRange.setMaxRadio(talkgroupRange.getMaxTalkgroup());
                    convertedAliasIds.add(radioRange);
                    continue;
                }
                if (talkgroupRange.getMaxTalkgroup() <= 65535) continue;
                radioRange = new RadioRange();
                radioRange.setProtocol(Protocol.APCO25);
                radioRange.setMinRadio(65536);
                radioRange.setMaxRadio(talkgroupRange.getMaxTalkgroup());
                convertedAliasIds.add(radioRange);
                talkgroupRange.setMaxTalkgroup(65535);
            }
            for (AliasID aliasID : convertedAliasIds) {
                ++converted;
                alias.addAliasID(aliasID);
            }
        }
        if (converted > 0) {
            mLog.info("Converted [" + converted + "] P25 talkgroups and/or talkgroup ranges to radio id or radio id ranges");
        }
    }

    private static void removeVersion1AudioRecordType(PlaylistV2 playlist) {
        int removed = 0;
        for (Channel channel : playlist.getChannels()) {
            RecordConfiguration recordConfiguration = channel.getRecordConfiguration();
            if (!recordConfiguration.contains(RecorderType.AUDIO)) continue;
            Iterator<RecorderType> it = recordConfiguration.getRecorders().iterator();
            while (it.hasNext()) {
                if (it.next() != RecorderType.AUDIO) continue;
                it.remove();
                ++removed;
            }
        }
        if (removed > 0) {
            mLog.info("Removed audio-record setting from [" + removed + "] channels. Audio recording is now a setting for each individual alias");
        }
    }

    private static void removeVersion1BinaryMessageLogger(PlaylistV2 playlist) {
        int removed = 0;
        for (Channel channel : playlist.getChannels()) {
            EventLogConfiguration eventLogConfiguration = channel.getEventLogConfiguration();
            if (!eventLogConfiguration.getLoggers().contains((Object)EventLogType.BINARY_MESSAGE)) continue;
            Iterator<EventLogType> it = eventLogConfiguration.getLoggers().iterator();
            while (it.hasNext()) {
                if (it.next() != EventLogType.BINARY_MESSAGE) continue;
                it.remove();
                ++removed;
            }
        }
        if (removed > 0) {
            mLog.info("Removed binary message event logging from [" + removed + "] channels. Use demodulated bitstream recorder instead");
        }
    }

    private static void removeVersion1NonRecordableAliasIdentifiers(PlaylistV2 playlist) {
        int removed = 0;
        for (Alias alias : playlist.getAliases()) {
            Iterator<AliasID> it = alias.getAliasIdentifiers().iterator();
            while (it.hasNext()) {
                if (it.next().getType() != AliasIDType.NON_RECORDABLE) continue;
                it.remove();
                ++removed;
            }
        }
        if (removed > 0) {
            mLog.info("Removed [" + removed + "] non-recordable alias identifiers from aliases");
        }
    }

    private static void removeVersion1SiteIdentifiers(PlaylistV2 playlist) {
        int removed = 0;
        for (Alias alias : playlist.getAliases()) {
            Iterator<AliasID> it = alias.getAliasIdentifiers().iterator();
            while (it.hasNext()) {
                if (it.next().getType() != AliasIDType.SITE) continue;
                it.remove();
                ++removed;
            }
        }
        if (removed > 0) {
            mLog.info("Removed [" + removed + "] site identifiers from aliases");
        }
    }

    private static void updateVersion1Talkgroups(PlaylistV2 playlist) {
        int updated = 0;
        int notUpdated = 0;
        AliasID next = null;
        ArrayList<Talkgroup> toAdd = new ArrayList<Talkgroup>();
        for (Alias alias : playlist.getAliases()) {
            Iterator<AliasID> it = alias.getAliasIdentifiers().iterator();
            block25: while (it.hasNext()) {
                next = it.next();
                switch (next.getType()) {
                    case LEGACY_TALKGROUP: {
                        LegacyTalkgroupID legacyTalkgroupId = (LegacyTalkgroupID)next;
                        String string = legacyTalkgroupId.getTalkgroup();
                        if (string != null) {
                            Integer value;
                            if (string.matches("[A-Fa-f\\d\\*]{4}") || string.matches("[A-Fa-f\\d\\*]{6}")) {
                                if (string.contains("*")) {
                                    ++notUpdated;
                                    break;
                                }
                                try {
                                    value = Integer.parseInt(string, 16);
                                    it.remove();
                                    toAdd.add(new Talkgroup(Protocol.APCO25, value));
                                    ++updated;
                                }
                                catch (Exception e) {
                                    ++notUpdated;
                                }
                                break;
                            }
                            if (string.matches(LTR_TALKGROUP)) {
                                if (string.contains("*")) {
                                    if (string.matches(LTR_TALKGROUP_WILDCARD)) {
                                        try {
                                            Integer group = Integer.parseInt(string.substring(5));
                                            for (int area = 0; area <= 1; ++area) {
                                                for (int channel = 1; channel <= 20; ++channel) {
                                                    int value2 = (area << 13) + (channel << 8) + group;
                                                    toAdd.add(new Talkgroup(Protocol.LTR, value2));
                                                    mLog.debug("LTR Talkgroup [" + string + "] updated to [" + value2 + "]");
                                                }
                                            }
                                            it.remove();
                                            ++updated;
                                        }
                                        catch (Exception e) {
                                            ++notUpdated;
                                        }
                                        break;
                                    }
                                    ++notUpdated;
                                    break;
                                }
                                try {
                                    Matcher m = LTR_PATTERN.matcher(string);
                                    if (!m.matches()) continue block25;
                                    int value3 = Integer.valueOf(m.group(3));
                                    toAdd.add(new Talkgroup(Protocol.LTR, value3 += Integer.valueOf(m.group(2)) << 8));
                                    it.remove();
                                    ++updated;
                                }
                                catch (Exception e) {
                                    ++notUpdated;
                                }
                                break;
                            }
                            if (!string.matches(PASSPORT_TALKGROUP)) break;
                            if (string.contains("*")) {
                                ++notUpdated;
                                break;
                            }
                            try {
                                value = Integer.parseInt(string);
                                it.remove();
                                toAdd.add(new Talkgroup(Protocol.PASSPORT, value));
                                ++updated;
                            }
                            catch (Exception e) {
                                ++notUpdated;
                            }
                            break;
                        }
                        it.remove();
                        break;
                    }
                    case FLEETSYNC: {
                        String fleetsync = ((FleetsyncID)next).getIdent();
                        try {
                            Matcher matcher = FLEETSYNC_PATTERN.matcher(fleetsync);
                            if (matcher.matches()) {
                                int value = Integer.valueOf(matcher.group(2));
                                toAdd.add(new Talkgroup(Protocol.FLEETSYNC, value += Integer.valueOf(matcher.group(1)) << 12));
                                it.remove();
                                ++updated;
                                break;
                            }
                            ++notUpdated;
                        }
                        catch (Exception e) {
                            ++notUpdated;
                        }
                        break;
                    }
                    case MDC1200: {
                        String mdc = ((MDC1200ID)next).getIdent();
                        if (mdc != null && mdc.matches("[A-Fa-f\\d\\*]{4}")) {
                            try {
                                int mdcValue = Integer.parseInt(mdc, 16);
                                toAdd.add(new Talkgroup(Protocol.MDC1200, mdcValue));
                                it.remove();
                                ++updated;
                            }
                            catch (Exception e) {
                                ++notUpdated;
                            }
                            break;
                        }
                        ++notUpdated;
                        break;
                    }
                    case MPT1327: {
                        String mpt = ((MPT1327ID)next).getIdent();
                        if (mpt == null || !mpt.matches("(\\d{3})-(\\d{4})")) break;
                        try {
                            Matcher matcher = MPT1327_PATTERN.matcher(mpt);
                            if (matcher.matches()) {
                                int value = Integer.valueOf(matcher.group(2));
                                toAdd.add(new Talkgroup(Protocol.MPT1327, value += Integer.valueOf(matcher.group(1)) << 13));
                                it.remove();
                                ++updated;
                                mLog.debug("MPT-1327 Talkgroup [" + mpt + "] updated to [" + value + "]");
                                break;
                            }
                            ++notUpdated;
                        }
                        catch (Exception e) {
                            ++notUpdated;
                        }
                        break;
                    }
                    case MIN: {
                        String min = ((Min)next).getMin();
                        if (!min.matches("[A-Fa-f\\d\\*]{6}")) break;
                        if (min.contains("*")) {
                            ++notUpdated;
                            break;
                        }
                        try {
                            Integer value = Integer.parseInt(min, 16);
                            it.remove();
                            toAdd.add(new Talkgroup(Protocol.PASSPORT, value));
                            ++updated;
                        }
                        catch (Exception e) {
                            ++notUpdated;
                        }
                        break;
                    }
                    case LTR_NET_UID: {
                        int uid = ((UniqueID)next).getUid();
                        toAdd.add(new Talkgroup(Protocol.LTR_NET, uid));
                        it.remove();
                        ++updated;
                    }
                }
            }
            for (AliasID aliasID : toAdd) {
                alias.addAliasID(aliasID);
            }
            toAdd.clear();
        }
        if (updated > 0) {
            mLog.info("Updated [" + updated + "] legacy talkgroup identifiers to new talkgroup format");
        }
        if (notUpdated > 0) {
            mLog.info("Unable to update [" + notUpdated + "] legacy talkgroup identifiers - please edit and convert to new talkgroup format");
        }
    }
}

