/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.playlist;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.audio.broadcast.BroadcastConfiguration;
import io.github.dsheirer.audio.broadcast.BroadcastModel;
import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.controller.channel.ChannelEvent;
import io.github.dsheirer.controller.channel.ChannelModel;
import io.github.dsheirer.controller.channel.ChannelProcessingManager;
import io.github.dsheirer.controller.channel.map.ChannelMap;
import io.github.dsheirer.controller.channel.map.ChannelMapModel;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.icon.IconModel;
import io.github.dsheirer.module.log.EventLogManager;
import io.github.dsheirer.playlist.PlaylistUpdater;
import io.github.dsheirer.playlist.PlaylistV2;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.playlist.PlaylistPreference;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.service.radioreference.RadioReference;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import io.github.dsheirer.util.ThreadPool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaylistManager
implements Listener<ChannelEvent> {
    private static final Logger mLog = LoggerFactory.getLogger(PlaylistManager.class);
    public static final int PLAYLIST_CURRENT_VERSION = 4;
    private AliasModel mAliasModel;
    private ChannelMapModel mChannelMapModel = new ChannelMapModel();
    private IconModel mIconModel;
    private BroadcastModel mBroadcastModel;
    private ChannelModel mChannelModel;
    private ChannelProcessingManager mChannelProcessingManager;
    private TunerManager mTunerManager;
    private UserPreferences mUserPreferences;
    private RadioReference mRadioReference;
    private AtomicBoolean mPlaylistSavePending = new AtomicBoolean();
    private ScheduledFuture<?> mPlaylistSaveFuture;
    private boolean mPlaylistLoading = false;

    public PlaylistManager(UserPreferences userPreferences, TunerManager tunerManager, AliasModel aliasModel, EventLogManager eventLogManager, IconModel iconModel) {
        this.mUserPreferences = userPreferences;
        this.mTunerManager = tunerManager;
        this.mAliasModel = aliasModel;
        this.mIconModel = iconModel;
        this.mBroadcastModel = new BroadcastModel(this.mAliasModel, this.mIconModel, userPreferences);
        this.mRadioReference = new RadioReference(this.mUserPreferences);
        this.mChannelModel = new ChannelModel(this.mAliasModel);
        this.mChannelProcessingManager = new ChannelProcessingManager(this.mChannelMapModel, eventLogManager, this.mTunerManager, this.mAliasModel, this.mUserPreferences);
        MyEventBus.getGlobalEventBus().register((Object)this.mChannelProcessingManager);
        this.mChannelModel.addListener(this.mChannelProcessingManager);
        this.mChannelProcessingManager.addChannelEventListener(this.mChannelModel);
        this.mChannelModel.addListener(this);
        this.mAliasModel.aliasList().addListener(c -> this.schedulePlaylistSave());
        this.mChannelMapModel.getChannelMaps().addListener(c -> this.schedulePlaylistSave());
        this.mBroadcastModel.addListener(broadcastEvent -> {
            switch (broadcastEvent.getEvent()) {
                case CONFIGURATION_ADD: 
                case CONFIGURATION_CHANGE: 
                case CONFIGURATION_DELETE: {
                    this.schedulePlaylistSave();
                    break;
                }
            }
        });
    }

    public ChannelModel getChannelModel() {
        return this.mChannelModel;
    }

    public ChannelProcessingManager getChannelProcessingManager() {
        return this.mChannelProcessingManager;
    }

    public AliasModel getAliasModel() {
        return this.mAliasModel;
    }

    public IconModel getIconModel() {
        return this.mIconModel;
    }

    public RadioReference getRadioReference() {
        return this.mRadioReference;
    }

    public BroadcastModel getBroadcastModel() {
        return this.mBroadcastModel;
    }

    public ChannelMapModel getChannelMapModel() {
        return this.mChannelMapModel;
    }

    public void init() {
        PlaylistV2 playlist = this.load();
        this.transferPlaylistToModels(playlist);
    }

    public void setPlaylist(Path path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Specified playlist path does not exist");
        }
        this.saveNow();
        this.mUserPreferences.getPlaylistPreference().setPlaylist(path);
        if (!Files.exists(path, new LinkOption[0])) {
            this.createEmptyPlaylist(path);
        }
        this.init();
    }

    public static boolean isPlaylist(Path path) {
        boolean bl;
        block9: {
            if (path == null || !Files.exists(path, new LinkOption[0])) {
                return false;
            }
            JacksonXmlModule xmlModule = new JacksonXmlModule();
            xmlModule.setDefaultUseWrapper(false);
            ObjectMapper objectMapper = new XmlMapper(xmlModule).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            InputStream in = Files.newInputStream(path, new OpenOption[0]);
            try {
                PlaylistV2 playlist = (PlaylistV2)objectMapper.readValue(in, PlaylistV2.class);
                bl = true;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    mLog.error("IO error while reading playlist file", (Throwable)ioe);
                    return false;
                }
            }
            in.close();
        }
        return bl;
    }

    public void createEmptyPlaylist(Path path) throws IOException {
        PlaylistV2 playlist = new PlaylistV2();
        try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
            JacksonXmlModule xmlModule = new JacksonXmlModule();
            xmlModule.setDefaultUseWrapper(false);
            XmlMapper objectMapper = new XmlMapper(xmlModule);
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            objectMapper.writeValue(out, (Object)playlist);
            out.flush();
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            mLog.error("Error while creating empty playlist [" + path.toString() + "]", (Throwable)e);
        }
    }

    private void clearModels() {
        this.mPlaylistLoading = true;
        this.mChannelProcessingManager.shutdown();
        this.mChannelModel.clear();
        this.mChannelMapModel.clear();
        this.mBroadcastModel.clear();
        this.mAliasModel.clear();
        this.mPlaylistLoading = false;
    }

    private void saveNow() {
        if (this.mPlaylistSaveFuture != null) {
            try {
                this.mPlaylistSaveFuture.cancel(true);
            }
            catch (Exception e) {
                mLog.error("Error trying to cancel pending playlist save");
            }
            this.mPlaylistSaveFuture = null;
        }
        if (this.mPlaylistSavePending.getAndSet(false)) {
            this.save();
        }
    }

    private void transferPlaylistToModels(PlaylistV2 playlist) {
        if (playlist != null) {
            this.clearModels();
            this.mPlaylistLoading = true;
            this.mAliasModel.addAliases(playlist.getAliases());
            this.mBroadcastModel.addBroadcastConfigurations(playlist.getBroadcastConfigurations());
            this.mChannelMapModel.addChannelMaps(playlist.getChannelMaps());
            this.mChannelModel.addChannels(playlist.getChannels());
            this.mPlaylistLoading = false;
        }
    }

    @Override
    public void receive(ChannelEvent event) {
        if (event.getChannel().getChannelType() == Channel.ChannelType.STANDARD) {
            switch (event.getEvent()) {
                case NOTIFICATION_ADD: 
                case NOTIFICATION_CONFIGURATION_CHANGE: 
                case NOTIFICATION_DELETE: {
                    this.schedulePlaylistSave();
                }
            }
        }
    }

    private void save() {
        PlaylistPreference playlistPreference = this.mUserPreferences.getPlaylistPreference();
        PlaylistV2 playlist = new PlaylistV2();
        playlist.setAliases(new ArrayList<Alias>(this.mAliasModel.getAliases()));
        playlist.setBroadcastConfigurations(new ArrayList<BroadcastConfiguration>(this.mBroadcastModel.getBroadcastConfigurations()));
        playlist.setChannels(new ArrayList<Channel>(this.mChannelModel.getChannels()));
        playlist.setChannelMaps(new ArrayList<ChannelMap>((Collection<ChannelMap>)this.mChannelMapModel.getChannelMaps()));
        playlist.setVersion(4);
        if (Files.exists(playlistPreference.getPlaylist(), new LinkOption[0])) {
            try {
                Files.copy(playlistPreference.getPlaylist(), playlistPreference.getPlaylistBackup(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                mLog.error("Error creating backup copy of current playlist prior to saving updates [" + playlistPreference.getPlaylist().toString() + "]", (Throwable)e);
            }
        }
        if (!Files.exists(playlistPreference.getPlaylistLock(), new LinkOption[0])) {
            try {
                Files.createFile(playlistPreference.getPlaylistLock(), new FileAttribute[0]);
            }
            catch (IOException e) {
                mLog.error("Error creating temporary lock file prior to saving playlist [" + playlistPreference.getPlaylistLock().toString() + "]", (Throwable)e);
            }
        }
        try (OutputStream out = Files.newOutputStream(playlistPreference.getPlaylist(), new OpenOption[0]);){
            JacksonXmlModule xmlModule = new JacksonXmlModule();
            xmlModule.setDefaultUseWrapper(false);
            XmlMapper objectMapper = new XmlMapper(xmlModule);
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            objectMapper.writeValue(out, (Object)playlist);
            out.flush();
            if (Files.exists(playlistPreference.getPlaylistLock(), new LinkOption[0])) {
                Files.delete(playlistPreference.getPlaylistLock());
            }
        }
        catch (IOException ioe) {
            mLog.error("IO error while writing the playlist to a file [" + playlistPreference.getPlaylist().toString() + "]", (Throwable)ioe);
        }
        catch (Exception e) {
            mLog.error("Error while saving playlist [" + playlistPreference.getPlaylist().toString() + "]", (Throwable)e);
        }
    }

    public PlaylistV2 load() {
        PlaylistPreference files = this.mUserPreferences.getPlaylistPreference();
        PlaylistV2 playlist = null;
        if (Files.exists(files.getPlaylistLock(), new LinkOption[0])) {
            mLog.info("Previous playlist save was incomplete -- restoring from backup file (if possible)");
            try {
                Files.delete(files.getPlaylist());
                if (Files.exists(files.getPlaylistBackup(), new LinkOption[0])) {
                    Files.copy(files.getPlaylistBackup(), files.getPlaylist(), new CopyOption[0]);
                }
                Files.delete(files.getPlaylistLock());
            }
            catch (IOException ioe) {
                mLog.error("Previous playlist save attempt was incomplete and there was an error restoring the playlist backup file", (Throwable)ioe);
            }
        }
        if (Files.exists(files.getPlaylist(), new LinkOption[0])) {
            mLog.info("Loading playlist [" + files.getPlaylist().toString() + "]");
            JacksonXmlModule xmlModule = new JacksonXmlModule();
            xmlModule.setDefaultUseWrapper(false);
            ObjectMapper objectMapper = new XmlMapper(xmlModule).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            try (InputStream in = Files.newInputStream(files.getPlaylist(), new OpenOption[0]);){
                playlist = (PlaylistV2)objectMapper.readValue(in, PlaylistV2.class);
                if (PlaylistUpdater.update(playlist)) {
                    this.schedulePlaylistSave();
                }
            }
            catch (IOException ioe) {
                mLog.error("IO error while reading playlist file", (Throwable)ioe);
            }
        } else if (Files.exists(files.getLegacyPlaylist(), new LinkOption[0])) {
            mLog.info("Loading legacy playlist [" + files.getLegacyPlaylist().toString() + "]");
            JacksonXmlModule xmlModule = new JacksonXmlModule();
            xmlModule.setDefaultUseWrapper(false);
            ObjectMapper objectMapper = new XmlMapper(xmlModule).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            try (InputStream in = Files.newInputStream(files.getLegacyPlaylist(), new OpenOption[0]);){
                playlist = (PlaylistV2)objectMapper.readValue(in, PlaylistV2.class);
                if (PlaylistUpdater.update(playlist)) {
                    mLog.info("Legacy playlist was updated to version [4] - saving");
                    this.schedulePlaylistSave();
                }
            }
            catch (IOException ioe) {
                mLog.error("IO error while reading playlist file", (Throwable)ioe);
            }
        } else {
            mLog.info("PlaylistManager - playlist not found at [" + files.getPlaylist().toString() + "] - creating new (empty) playlist");
        }
        if (playlist == null) {
            playlist = new PlaylistV2();
            this.schedulePlaylistSave();
        }
        return playlist;
    }

    public void schedulePlaylistSave() {
        if (!this.mPlaylistLoading && this.mPlaylistSavePending.compareAndSet(false, true)) {
            this.mPlaylistSaveFuture = ThreadPool.SCHEDULED.schedule(new PlaylistSaveTask(), 2L, TimeUnit.SECONDS);
        }
    }

    public class PlaylistSaveTask
    implements Runnable {
        @Override
        public void run() {
            PlaylistManager.this.save();
            PlaylistManager.this.mPlaylistSaveFuture = null;
            PlaylistManager.this.mPlaylistSavePending.set(false);
        }
    }
}

