/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.monitor;

import io.github.dsheirer.log.LoggingSuppressor;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.util.ThreadPool;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceMonitor {
    private static final Logger sLog = LoggerFactory.getLogger(ResourceMonitor.class);
    private static final LoggingSuppressor sLogSuppressor = new LoggingSuppressor(sLog);
    private static final int SCALOR_MEGABYTE = 0x100000;
    private UserPreferences mUserPreferences;
    private ScheduledFuture<?> mMemoryCpuMonitorFuture;
    private ScheduledFuture<?> mStorageMonitorFuture;
    private LongProperty mMemoryTotal = new SimpleLongProperty();
    private LongProperty mMemoryAllocated = new SimpleLongProperty();
    private LongProperty mMemoryUsed = new SimpleLongProperty();
    private DoubleProperty mJavaMemoryUsedPercentage = new SimpleDoubleProperty();
    private DoubleProperty mSystemMemoryUsedPercentage = new SimpleDoubleProperty();
    private DoubleProperty mCpuPercentage = new SimpleDoubleProperty();
    private BooleanProperty mCpuAvailable = new SimpleBooleanProperty();
    private DoubleProperty mDirectoryUsePercentEventLogs = new SimpleDoubleProperty();
    private DoubleProperty mDirectoryUsePercentRecordings = new SimpleDoubleProperty();
    private StringProperty mFileSizeEventLogs = new SimpleStringProperty();
    private StringProperty mFileSizeRecordings = new SimpleStringProperty();
    private OperatingSystemMXBean mOperatingSystemMXBean;

    public ResourceMonitor(UserPreferences userPreferences) {
        this.mUserPreferences = userPreferences;
        try {
            this.mOperatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        }
        catch (Exception e) {
            sLog.error("Error accessing operating system MX bean to monitor CPU usage", (Throwable)e);
        }
        this.mMemoryTotal.set(Runtime.getRuntime().maxMemory());
    }

    public void start() {
        if (this.mMemoryCpuMonitorFuture == null) {
            this.mMemoryCpuMonitorFuture = ThreadPool.SCHEDULED.scheduleAtFixedRate(() -> this.updateCpuMemory(), 1L, 1L, TimeUnit.SECONDS);
        }
        if (this.mStorageMonitorFuture == null) {
            this.mStorageMonitorFuture = ThreadPool.SCHEDULED.scheduleAtFixedRate(() -> this.updateDirectoryUsage(), 1L, 30L, TimeUnit.SECONDS);
        }
    }

    public void stop() {
        if (this.mMemoryCpuMonitorFuture != null) {
            this.mMemoryCpuMonitorFuture.cancel(true);
            this.mMemoryCpuMonitorFuture = null;
        }
        if (this.mStorageMonitorFuture != null) {
            this.mStorageMonitorFuture.cancel(true);
            this.mStorageMonitorFuture = null;
        }
    }

    private void updateCpuMemory() {
        double cpuLoadScaled = 0.0;
        if (this.mOperatingSystemMXBean != null) {
            double load = this.mOperatingSystemMXBean.getSystemLoadAverage();
            cpuLoadScaled = load / (double)this.mOperatingSystemMXBean.getAvailableProcessors();
        }
        double loadFinal = cpuLoadScaled;
        Platform.runLater(() -> {
            this.mMemoryAllocated.set(Runtime.getRuntime().totalMemory());
            this.mMemoryUsed.set(this.mMemoryAllocated.getValue() - Runtime.getRuntime().freeMemory());
            this.mJavaMemoryUsedPercentage.set((double)this.mMemoryUsed.get() / (double)this.mMemoryAllocated.get());
            this.mSystemMemoryUsedPercentage.set((double)this.mMemoryAllocated.get() / (double)this.mMemoryTotal.get());
            this.mCpuPercentage.set(loadFinal > 0.0 ? loadFinal : 0.0);
            this.mCpuAvailable.set(loadFinal >= 0.0);
        });
    }

    private void updateDirectoryUsage() {
        long thresholdEventLog = this.mUserPreferences.getDirectoryPreference().getDirectoryMaxUsageEventLogs() * 0x100000;
        long thresholdRecording = this.mUserPreferences.getDirectoryPreference().getDirectoryMaxUsageRecordings() * 0x100000;
        Path recordingPath = this.mUserPreferences.getDirectoryPreference().getDirectoryRecording();
        Path eventLogsPath = this.mUserPreferences.getDirectoryPreference().getDirectoryEventLog();
        try {
            FileStore recordingFileStore = Files.getFileStore(recordingPath);
            FileStore eventLogsFileStore = Files.getFileStore(eventLogsPath);
            long recordingAvailable = recordingFileStore.getUsableSpace();
            long eventLogsAvailable = eventLogsFileStore.getUsableSpace();
            long eventLogUsed = FileUtils.sizeOfDirectory((File)eventLogsPath.toFile());
            long recordingUsed = FileUtils.sizeOfDirectory((File)recordingPath.toFile());
            long eventLogMax = Math.min(thresholdEventLog, eventLogUsed + eventLogsAvailable);
            long recordingMax = Math.min(thresholdRecording, recordingUsed + recordingAvailable);
            Platform.runLater(() -> {
                this.mDirectoryUsePercentEventLogs.set((double)eventLogUsed / (double)eventLogMax);
                this.mDirectoryUsePercentRecordings.set((double)recordingUsed / (double)recordingMax);
                this.mFileSizeEventLogs.set((Object)FileUtils.byteCountToDisplaySize((long)eventLogUsed));
                this.mFileSizeRecordings.set((Object)FileUtils.byteCountToDisplaySize((long)recordingUsed));
            });
        }
        catch (IOException ioe) {
            sLogSuppressor.error("Log Once", 1, "Unable to monitor file system - " + ioe.getMessage());
        }
    }

    public DoubleProperty directoryUsePercentEventLogsProperty() {
        return this.mDirectoryUsePercentEventLogs;
    }

    public DoubleProperty directoryUsePercentRecordingsProperty() {
        return this.mDirectoryUsePercentRecordings;
    }

    public StringProperty fileSizeEventLogsProperty() {
        return this.mFileSizeEventLogs;
    }

    public StringProperty fileSizeRecordingsProperty() {
        return this.mFileSizeRecordings;
    }

    public DoubleProperty cpuPercentageProperty() {
        return this.mCpuPercentage;
    }

    public BooleanProperty cpuAvailableProperty() {
        return this.mCpuAvailable;
    }

    public LongProperty memoryTotalProperty() {
        return this.mMemoryTotal;
    }

    public LongProperty memoryAllocatedProperty() {
        return this.mMemoryAllocated;
    }

    public LongProperty memoryUsedProperty() {
        return this.mMemoryUsed;
    }

    public DoubleProperty javaMemoryUsedPercentageProperty() {
        return this.mJavaMemoryUsedPercentage;
    }

    public DoubleProperty systemMemoryUsedPercentageProperty() {
        return this.mSystemMemoryUsedPercentage;
    }
}

