/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.log;

import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.message.IMessageListener;
import io.github.dsheirer.module.log.EventLogger;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.util.TimeStamp;
import java.nio.file.Path;

public class MessageEventLogger
extends EventLogger
implements IMessageListener,
Listener<IMessage> {
    private Type mType;

    public MessageEventLogger(Path logDirectory, String fileNameSuffix, Type type, long frequency) {
        super(logDirectory, fileNameSuffix, frequency);
        this.mType = type;
    }

    @Override
    public Listener<IMessage> getMessageListener() {
        return this;
    }

    @Override
    public void reset() {
    }

    @Override
    public void receive(IMessage message) {
        StringBuilder sb = new StringBuilder();
        sb.append(TimeStamp.getTimeStamp(message.getTimestamp(), " "));
        sb.append(",");
        sb.append(message.isValid() ? "PASSED" : "FAILED");
        sb.append(",");
        sb.append(message.toString());
        this.write(sb.toString());
    }

    @Override
    public String getHeader() {
        return this.mType.toString() + " Message Logger\n";
    }

    public static enum Type {
        BINARY,
        DECODED;

    }
}

