/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.log;

import io.github.dsheirer.module.Module;
import io.github.dsheirer.util.TimeStamp;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventLogger
extends Module {
    private static final Logger mLog = LoggerFactory.getLogger(EventLogger.class);
    private Path mLogDirectory;
    private String mFileNameSuffix;
    private String mLogFileName;
    private long mFrequency;
    protected Writer mLogFile;

    public EventLogger(Path logDirectory, String fileNameSuffix, long frequency) {
        this.mLogDirectory = logDirectory;
        this.mFileNameSuffix = fileNameSuffix;
        this.mFrequency = frequency;
    }

    public String toString() {
        if (this.mLogFileName != null) {
            return this.mLogFileName;
        }
        return "Unknown";
    }

    public abstract String getHeader();

    @Override
    public void start() {
        if (this.mLogFile == null) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(this.mLogDirectory);
                sb.append(File.separator);
                sb.append(TimeStamp.getLongTimeStamp("_"));
                sb.append("_");
                sb.append(this.mFrequency);
                sb.append("_Hz_");
                sb.append(this.mFileNameSuffix);
                this.mLogFileName = sb.toString();
                this.mLogFile = new OutputStreamWriter(new FileOutputStream(this.mLogFileName));
                this.write(this.getHeader());
            }
            catch (FileNotFoundException e) {
                mLog.error("Couldn't create log file in directory:" + String.valueOf(this.mLogDirectory));
            }
        }
    }

    @Override
    public void stop() {
        if (this.mLogFile != null) {
            try {
                this.mLogFile.flush();
                this.mLogFile.close();
                this.mLogFile = null;
            }
            catch (Exception e) {
                mLog.error("Couldn't close log file:" + this.mFileNameSuffix);
            }
        }
    }

    protected void write(String eventLogEntry) {
        try {
            if (this.mLogFile != null) {
                this.mLogFile.write((eventLogEntry != null ? eventLogEntry : "") + "\n");
                this.mLogFile.flush();
            }
        }
        catch (Exception e) {
            mLog.error("Error writing entry to event log file", (Throwable)e);
        }
    }
}

