/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.log;

import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.module.Module;
import io.github.dsheirer.module.log.DecodeEventLogger;
import io.github.dsheirer.module.log.EventLogType;
import io.github.dsheirer.module.log.EventLogger;
import io.github.dsheirer.module.log.MessageEventLogger;
import io.github.dsheirer.module.log.config.EventLogConfiguration;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.source.config.SourceConfigTuner;
import io.github.dsheirer.util.StringUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventLogManager {
    private static final Logger mLog = LoggerFactory.getLogger(EventLogManager.class);
    private UserPreferences mUserPreferences;
    private AliasModel mAliasModel;

    public EventLogManager(AliasModel aliasModel, UserPreferences userPreferences) {
        this.mAliasModel = aliasModel;
        this.mUserPreferences = userPreferences;
    }

    public List<Module> getLoggers(Channel channel) {
        EventLogConfiguration config = channel.getEventLogConfiguration();
        String prefix = StringUtils.replaceIllegalCharacters(channel.getName());
        long frequency = 0L;
        if (channel.getSourceConfiguration() instanceof SourceConfigTuner) {
            frequency = ((SourceConfigTuner)channel.getSourceConfiguration()).getFrequency();
        }
        ArrayList<Module> loggers = new ArrayList<Module>();
        for (EventLogType type : config.getLoggers()) {
            switch (type) {
                case CALL_EVENT: 
                case DECODED_MESSAGE: {
                    if (channel.getChannelType() != Channel.ChannelType.STANDARD) break;
                    loggers.add(this.getLogger(type, prefix, frequency));
                    break;
                }
                case TRAFFIC_CALL_EVENT: 
                case TRAFFIC_DECODED_MESSAGE: {
                    if (channel.getChannelType() != Channel.ChannelType.TRAFFIC) break;
                    loggers.add(this.getLogger(type, prefix, frequency));
                }
            }
        }
        return loggers;
    }

    public EventLogger getLogger(EventLogType eventLogType, String prefix, long frequency) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        sb.append(eventLogType.getFileSuffix());
        sb.append(".log");
        Path eventLogDirectory = this.mUserPreferences.getDirectoryPreference().getDirectoryEventLog();
        switch (eventLogType) {
            case CALL_EVENT: {
                return new DecodeEventLogger(this.mAliasModel, eventLogDirectory, sb.toString(), frequency);
            }
            case DECODED_MESSAGE: {
                return new MessageEventLogger(eventLogDirectory, sb.toString(), MessageEventLogger.Type.DECODED, frequency);
            }
            case TRAFFIC_CALL_EVENT: {
                return new DecodeEventLogger(this.mAliasModel, eventLogDirectory, sb.toString(), frequency);
            }
            case TRAFFIC_DECODED_MESSAGE: {
                return new MessageEventLogger(eventLogDirectory, sb.toString(), MessageEventLogger.Type.DECODED, frequency);
            }
        }
        return null;
    }
}

