/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.tait;

import io.github.dsheirer.bits.IBinarySymbolProcessor;
import io.github.dsheirer.bits.MessageFramer;
import io.github.dsheirer.bits.SyncPattern;
import io.github.dsheirer.dsp.afsk.AFSK1200Decoder;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.afsk.AbstractAFSKDecoder;
import io.github.dsheirer.module.decode.tait.Tait1200ANIMessageProcessor;
import io.github.dsheirer.module.decode.tait.Tait1200GPSMessageProcessor;

public class Tait1200Decoder
extends AbstractAFSKDecoder
implements IBinarySymbolProcessor {
    private static final int MESSAGE_LENGTH = 440;
    private MessageFramer mMessageFramerGPS;
    private MessageFramer mMessageFramerANI;
    private Tait1200GPSMessageProcessor mMessageAProcessor;
    private Tait1200ANIMessageProcessor mMessageBProcessor;

    protected Tait1200Decoder(AFSK1200Decoder decoder) {
        super(decoder);
        this.init();
    }

    public Tait1200Decoder() {
        super(AFSK1200Decoder.Output.NORMAL);
        this.init();
    }

    private void init() {
        this.getDecoder().setSymbolProcessor(this);
        this.mMessageFramerGPS = new MessageFramer(SyncPattern.TAIT_CCDI_GPS_MESSAGE.getPattern(), 440);
        this.mMessageFramerANI = new MessageFramer(SyncPattern.TAIT_SELCAL_MESSAGE.getPattern(), 440);
        this.mMessageAProcessor = new Tait1200GPSMessageProcessor();
        this.mMessageBProcessor = new Tait1200ANIMessageProcessor();
        this.mMessageFramerGPS.addMessageListener(this.mMessageAProcessor);
        this.mMessageFramerANI.addMessageListener(this.mMessageBProcessor);
        this.mMessageAProcessor.setMessageListener(this.getMessageListener());
        this.mMessageBProcessor.setMessageListener(this.getMessageListener());
    }

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.TAIT_1200;
    }

    @Override
    public void process(boolean symbol) {
        this.mMessageFramerANI.process(symbol);
        this.mMessageFramerGPS.process(symbol);
    }

    public MessageFramer getANIMessageFramer() {
        return this.mMessageFramerANI;
    }

    public MessageFramer getGPSMessageFramer() {
        return this.mMessageFramerGPS;
    }
}

