/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.passport;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.filter.FilterElement;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.message.MessageType;
import io.github.dsheirer.module.decode.passport.PassportMessage;
import java.util.function.Function;

public class PassportMessageFilter
extends Filter<IMessage, MessageType> {
    private KeyExtractor mKeyExtractor = new KeyExtractor(this);

    public PassportMessageFilter() {
        super("Passport Messages");
        this.add(new FilterElement<MessageType>(MessageType.CA_STRT));
        this.add(new FilterElement<MessageType>(MessageType.SY_IDLE));
        this.add(new FilterElement<MessageType>(MessageType.ID_TGAS));
        this.add(new FilterElement<MessageType>(MessageType.ID_ESNH));
        this.add(new FilterElement<MessageType>(MessageType.CA_PAGE));
        this.add(new FilterElement<MessageType>(MessageType.ID_RDIO));
        this.add(new FilterElement<MessageType>(MessageType.DA_STRT));
        this.add(new FilterElement<MessageType>(MessageType.RA_REGI));
    }

    @Override
    public boolean canProcess(IMessage message) {
        return message instanceof PassportMessage && super.canProcess(message);
    }

    @Override
    public Function<IMessage, MessageType> getKeyExtractor() {
        return this.mKeyExtractor;
    }

    private class KeyExtractor
    implements Function<IMessage, MessageType> {
        private KeyExtractor(PassportMessageFilter passportMessageFilter) {
        }

        @Override
        public MessageType apply(IMessage message) {
            if (message instanceof PassportMessage) {
                PassportMessage passport = (PassportMessage)message;
                return passport.getMessageType();
            }
            return null;
        }
    }
}

